package JavaIntapi::GetVcards;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

use Yandex::I18n qw/iget/;
use Yandex::HashUtils qw/hash_cut hash_merge/;

has '+profile_name' => (default => 'intapi_java:get_vcards');
has '+items'  => (isa => 'Maybe[ArrayRef[Int]]');
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'client_id'    => (is => 'ro', isa => 'Id');
has 'with_vcards_uses_count' => (is => 'ro', isa => 'Bool', default => 0);

sub _method { 'vcard/get_vcards' }

sub _get_url_params {
    my ($self) = @_;
    return {operator_uid => $self->operator_uid, client_id => $self->client_id};
}

sub _prepare {
    my ($self) = @_;
    return { vcard_ids => $self->items, 
             with_vcards_uses_count => ($self->with_vcards_uses_count ? 1 : 0) };
}

sub _postprocess {
    my ($self, $result, $error) = @_;
    my $vcards = $self->_convert_vcards_from_java_model($result->{vcards} // []);
    return { vcards => $vcards, vcards_uses_count => $result->{vcards_uses_count} // {} };
}

sub _convert_vcards_from_java_model {
    my ($class, $vcards) = @_;

    my $fields_p2j = { map { $_ => $_ } qw/ 
        country city street house build apart metro_name
        ogrn org_details_id extra_message uid country_geo_id geo_id/ };
    $fields_p2j = { %$fields_p2j, 
        vcard_id      => 'id', 
        cid           => 'campaign_id', 
        name          => 'company_name', 
        contactperson => 'contact_person', 
        contact_email => 'email', 
        worktime      => 'work_time',
        metro         => 'metro_id', 
    };
    my $result = [];

    my %WEEK = (
        0 => iget('пн'),
        1 => iget('вт'),
        2 => iget('ср'), 
        3 => iget('чт'), 
        4 => iget('пт'), 
        5 => iget('сб'),
        6 => iget('вс')
    );

    foreach my $v (@$vcards) {
        my $vcard = { map { $_ => $v->{ $fields_p2j->{$_} } } keys %$fields_p2j };

        @$vcard{qw/country_code city_code phone ext/} = 
            @{ $v->{phone} }{qw/country_code city_code phone_number extension/};

        @$vcard{qw/im_client im_login/} = 
            @{ $v->{instant_messenger} }{qw/type login/};
        
        $vcard->{manual_point}  = $v->{manual_point} ? join(',', @{ $v->{manual_point} }{qw/x y/}) : '';
        $vcard->{manual_bounds} = $v->{manual_point} ? join(',', @{ $v->{manual_point} }{qw/x1 y1 x2 y2/}) : '';

        $vcard->{auto_point}  = $v->{auto_point} ? join(',', @{ $v->{auto_point} }{qw/x y/}) : '';
        $vcard->{auto_bounds} = $v->{auto_point} ? join(',', @{ $v->{auto_point} }{qw/x1 y1 x2 y2/}) : '';

        $vcard->{auto_precision} = lc($v->{precision} // '');

        $vcard->{worktimes} = [ map { hash_merge({d1 => $WEEK{$_->{d1}}, d2 => $WEEK{$_->{d2}}}, hash_cut($_, qw/h1 m1 h2 m2/)) } 
                                @{ $v->{worktimes} // [] } ];
        push @$result, $vcard;
    }
    return $result;
}

__PACKAGE__->meta->make_immutable;

1;
