package JavaIntapi::InternalAdPlaces::ControllablePlaces;
use Direct::Modern;
use Mouse;

use JSON 'to_json';

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'GET');
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'product_client_id' => (is => 'ro', isa => 'Id');

sub _method { '/internalads/places/controllable_places' }

sub _get_url_params {
    my ($self) = @_;

    return {
        operator_uid => $self->operator_uid,
        product_client_id => $self->product_client_id,
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if ( !$result->{success} || !$result->{places} ) {
        die to_json($result);
    }

    return $result->{places};
}

1;
