package JavaIntapi::MigrateMobileApps;
use Direct::Modern;
use Mouse;

use Yandex::ORM::Types;

use JSON 'to_json';

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'POST');
has '+request_timeout' => (default => 300);
has 'client_id' => (is => 'ro', isa => 'Id');

sub _method { 'mobile_app/migrateClient' }

sub _get_url_params {
    my ($self) = @_;
    return { client_id => $self->client_id };
}

sub _prepare { return {}; }

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if ( !$result->{success} ) {
        die to_json($result);
    }

    return 'ok';
}

1;
