package JavaIntapi::Notifications;

use JSON;
use Settings;
use Yandex::HTTP;
use Yandex::I18n;
use Yandex::Trace;

use Direct::Modern;

our $INTAPI_REQUEST_TIMEOUT = 15;

our @EXPORT = qw/
    _get_url_monitoring_notifications
    /;

sub _get_url_monitoring_notifications {
    my ($urls_to_check) = @_;

    my $profile = Yandex::Trace::new_profile('java_notification:url_monitoring');

    state ($log, $json);
    $log //= Yandex::Log->new(
        no_log => 1,
        use_syslog => 1,
        syslog_prefix => 'INTAPI-JAVA',
        log_file_name => "Notifications.log",
    );
    $json //= JSON->new->allow_unknown(1)->allow_blessed(1)->convert_blessed(1);

    my $url = Yandex::HTTP::make_url(
        $Settings::DIRECT_INTAPI_URL . 'notification/urlmonitoring',
        {}
    );

    my $trace_id = Yandex::Trace::current_span_id();
    my $trace_header = join(',', map {$_ // 0} $trace_id, Yandex::Trace::generate_traceid(), $trace_id, 0);

    $log->out(['POST', $url, 'X-Yandex-Trace:', $trace_header]);

    my $response = Yandex::HTTP::http_parallel_request(POST => { 1 => {
                url => $url,
                body => encode_json($urls_to_check)
            }},
        timeout => $INTAPI_REQUEST_TIMEOUT,
        log => $log,
        headers => {
            'Accept' => 'application/json',
            'Content-type' => 'application/json',
            'X-Detected-Locale' => _get_lang_for_request(),
            'X-Yandex-Trace' => $trace_header
        },
    )->{1};

    my ($result, $error);
    if ($response->{is_success}) {
        utf8::decode($response->{content});
        my $content = $json->decode($response->{content});
        $result = $content->{dead_urls} if $response->{content};
    } else {
        $error = {
            server_status => $response->{headers}->{Status},
            server_error => 'Server returned an error'
        };
    }

    return $result, $error;
}

sub _get_lang_for_request {
    my %LANG_ALIAS = (ua => 'uk');
    my $lang = Yandex::I18n::current_lang();
    return $LANG_ALIAS{$lang} || $lang;
}

1;


