package JavaIntapi::SaveTurbolandings;
use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'POST');
has 'client_id' => (is => 'ro', isa => 'Id');
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'turbolandings' => (is => 'ro', isa => 'ArrayRef[HashRef]');

has '+profile_name' => (default => 'intapi_java:save_turbolanding');

sub _method {'turboLandings/save_turbolanding'}

sub _get_url_params {
    my ($self) = @_;
    return { client_id => $self->client_id, operator_uid => $self->operator_uid };
}

sub _prepare {
    my ($self) = @_;
    return $self->turbolandings;
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    return $result;
}

1;
