package JavaIntapi::SendMetricsToSolomon;
use Direct::Modern;
use Mouse;

use Settings;
use LogTools;

=head1 DESCRIPTION

    Обвязка к java-ручке отправки данных в Solomon.

    На текущий момент java-ручка поддерживает только тип метрики RATE - здесь оно задается по умолчанию, можно не передвать.
    Подробнее про типы метрик: https://wiki.yandex-team.ru/solomon/userguide/datamodel/#types

    Пример вызова:
        my $reslut = JavaIntapi::SendMetricsToSolomon->new(
                        items => [
                            {labels => {label_1 => "test_label"}, name => "test.value",long_value => 13},
                            {name => "test.value2",type => "RATE",long_value => 11},
                        ]
                     )->call();

=cut

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'POST');
has '+profile_name' => (default => 'intapi_java:metrics_solomon');
has '+request_timeout' => (default => 10);

sub _method {'metrics/solomon'}

sub _get_url_params { undef }

sub _prepare {
    my ($self) = @_;
    my @result;

    for my $metric (@{$self->items}) {
        my $labels = {
            # метка env обязательна
            'env' => $Settings::CONFIGURATION,
            %{ref $metric->{labels} eq 'HASH' ? $metric->{labels} : {}},
        };
        my $item = {
            labels => $labels,
            name => $metric->{name},
            # На текущий момент java-ручка поддерживает только тип RATE
            type => $metric->{type} // 'RATE',
        };
        $item->{long_value} = $metric->{long_value} if defined $metric->{long_value};
        $item->{double_value} = $metric->{double_value} if defined $metric->{double_value};

        push @result, $item;
    }

    return \@result;
}

# переопределяем, так как не хотим уронить вызывающий код. никогда.
sub call {
    my ($self) = @_;
    my $error = eval { $self->SUPER::call() };
    if ($error || $@) {
        LogTools::log_messages("metrics/solomon", "Failed to send metrics to solomon via intapi " . ($error || $@));
    }
    return undef;
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ( !$result->{success} ) {
        return $error;
    }

    return undef;
}

1;
