package JavaIntapi::SendMoneyOutWarning;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:send_money_out_warnings');

# Ожидается
#   {
#       uid1 => {cid=> cid, prm1 => "val1", prm1 => "val2", ...},
#       uid2 => {....},
#       ...
#   }
# Все параметры шаблона (val1, val2, и.т.п) должны быть строковыми значениями.
# email, на который будет отправлено сообщение, определяется по uid на стороне java-кода.
# Параметры шаблона передаются в шаблон письма без модификации
has 'template_params_by_uid' => (is => 'ro', isa => 'HashRef');

sub _method { 'users/send_money_out_warning' }

sub _get_url_params {
    my ($self) = @_;
    return {};
}

sub _prepare {
    my ($self) = @_;

    my $data = $self->template_params_by_uid();
    my @request_body;
    foreach my $uid (keys %$data) {
        my $user_data = $data->{$uid};
        my $c_email = delete $user_data->{_campaign_email};
        my $cid = $user_data->{cid}; # оставляем в данных на случай, если в сообщении понадобится подставлять в урлы
        my $request_item =  { uid => $uid, cid => $cid, template_data => $user_data };
        $request_item->{custom_email} = $c_email;
        push @request_body, $request_item;
    }

    return \@request_body;
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    $result //= {};
    warn( $self->profile_name,': ', $error) if $error;

    # в ответе ручки для каждого cid из входных данных возвращается статус успешности отправки.
    # Если false - значит не смогли отправить сообщение из-за проблем в рассыляторе
    # {cid1 => 1, cid2 => 1, cid3 => 0, ...}
    return $result;
}

__PACKAGE__->meta->make_immutable;

1;
