package JavaIntapi::StrategySave;
use Direct::Modern;
use Mouse;
use JSON;

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'POST');
has 'client_id' => (is => 'ro', isa => 'Id');
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'cid' => (is => 'ro', isa => 'Id');
has 'json_strategy' => (is => 'ro', isa => 'HashRef');
has 'is_attribution_model_changed' => (is => 'ro', isa => 'Bool');

has '+profile_name' => (default => 'intapi_java:strategy_save');

sub _method {'strategy/save_strategy'}

sub _get_url_params {
    my ($self) = @_;
    return { client_id => $self->client_id, operator_uid => $self->operator_uid };
}

sub _prepare {
    my ($self) = @_;
    my %result;
    $result{cid} = $self->cid;
    $result{json_strategy} = encode_json($self->json_strategy);
    $result{json_day_budget} = "";
    $result{is_attribution_model_changed} = $self->is_attribution_model_changed ? JSON::true : JSON::false;
    return \%result;
}

sub _postprocess {
    my ($self, $result, $error) = @_;
    my $validation_errors = $result->{validation_result}->{errors} // [];
    if (@$validation_errors) {
        my $error_text = [];
        foreach my $validation_error (@$validation_errors) {
            push @$error_text, $validation_error->{text};
        }
        $result->{error} = $error_text;
    }
    return $result;
}

1;
