package JavaIntapi::UpdateBidModifiers;

use Direct::Modern;
use Mouse;

use Yandex::I18n qw/iget/;

use Direct::Validation::Errors;
use HierarchicalMultipliers::Base;

extends 'JavaIntapiClientBase';

=head2

    Сохранение корректировок для кампании/группы объявлений.

=cut

# Аргументы ручки
has 'campaign_id'  => (is => 'ro', isa => 'Id', required => 1);
has 'adgroup_id'   => (is => 'ro', isa => 'Id');
has 'campaign_type'  => (is => 'ro', isa => 'Str', required => 1);

has 'mobile_multiplier' => (is => 'ro', isa => 'HashRef');
has 'desktop_multiplier' => (is => 'ro', isa => 'HashRef');
has 'tablet_multiplier' => (is => 'ro', isa => 'HashRef');
has 'desktop_only_multiplier' => (is => 'ro', isa => 'HashRef');
has 'smarttv_multiplier' => (is => 'ro', isa => 'HashRef');
has 'demography_multiplier' => (is => 'ro', isa => 'HashRef');
has 'retargeting_multiplier' => (is => 'ro', isa => 'HashRef');
has 'geo_multiplier' => (is => 'ro', isa => 'HashRef');
has 'ab_segment_multiplier' => (is => 'ro', isa => 'HashRef');
has 'video_multiplier' => (is => 'ro', isa => 'HashRef');
has 'performance_tgo_multiplier' => (is => 'ro', isa => 'HashRef');
has 'inventory_multiplier' => (is => 'ro', isa => 'HashRef');
has 'banner_type_multiplier' => (is => 'ro', isa => 'HashRef');
has 'weather_multiplier' => (is => 'ro', isa => 'HashRef');
has 'expression_multipliers' => (is => 'ro', isa => 'ArrayRef');
has 'trafaret_position_multiplier' => (is => 'ro', isa => 'HashRef');

has '+profile_name' => (default => 'intapi_java:update_bidmodifiers');
has '+warn_if_request_failed' => (default => 0);
has '+accept_header' => (default => 'application/json');
has '+log_enabled' => (default => 1);

around BUILDARGS => sub {
    my $orig = shift;
    my $class = shift;
    my %params = @_;

    my $multipliers_for_java = HierarchicalMultipliers::Base::wrap_expression_multipliers(\%params);

    return $class->$orig(%$multipliers_for_java);
};

sub _method { 'bidmodifiers/update' }

sub _get_url_params {
    my ($self) = @_;
    return {
        campaignId  => $self->campaign_id,
        adGroupId   => $self->adgroup_id,
        campaignType  => $self->campaign_type,
    };
}

sub _prepare {
    my ($self) = @_;

    my %result;
    $result{mobile_multiplier} = $self->mobile_multiplier if $self->mobile_multiplier;
    $result{desktop_multiplier} = $self->desktop_multiplier if $self->desktop_multiplier;
    $result{tablet_multiplier} = $self->tablet_multiplier if $self->tablet_multiplier;
    $result{desktop_only_multiplier} = $self->desktop_only_multiplier if $self->desktop_only_multiplier;
    $result{smarttv_multiplier} = $self->smarttv_multiplier if $self->smarttv_multiplier;
    $result{demography_multiplier} = $self->demography_multiplier if $self->demography_multiplier;
    $result{retargeting_multiplier} = $self->retargeting_multiplier if $self->retargeting_multiplier;
    $result{geo_multiplier} = $self->geo_multiplier if $self->geo_multiplier;
    $result{ab_segment_multiplier} = $self->ab_segment_multiplier if $self->ab_segment_multiplier;
    $result{video_multiplier} = $self->video_multiplier if $self->video_multiplier;
    $result{performance_tgo_multiplier} = $self->performance_tgo_multiplier if $self->performance_tgo_multiplier;
    $result{inventory_multiplier} = $self->inventory_multiplier if $self->inventory_multiplier;
    $result{banner_type_multiplier} = $self->banner_type_multiplier if $self->banner_type_multiplier;
    $result{weather_multiplier} = $self->weather_multiplier if $self->weather_multiplier;
    $result{expression_multipliers} = $self->expression_multipliers if $self->expression_multipliers;
    $result{trafaret_position_multiplier} = $self->trafaret_position_multiplier if $self->trafaret_position_multiplier;
    return \%result;
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ($result && %$result) {
            return $result;
    } else {
            die "error in call_intapi_java('bidmodifiers/update'): " . ($error // '');
    }
}

__PACKAGE__->meta->make_immutable;

1;
