package JavaIntapi::UpdateCounterGrants;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:update_counter_grants');
has 'uids_by_counter_id' => (is => 'ro', isa => 'HashRef[ArrayRef]');
has 'operator_uid' => (is => 'ro', isa => 'Id');

sub _method { 'turboLandings/update_counter_grants' }

sub _get_url_params {
    my ($self) = @_;
    return {operator_uid => $self->operator_uid};
}

sub _prepare {
    my ($self) = @_;
    my %data = %{ $self->uids_by_counter_id // {} };
    my $request_body = [ map { { "counter_id" => $_, "user_ids" => $data{ $_ } } } keys %data ];
    return $request_body;
}

sub _postprocess {
    my ($self, $result, $error) = @_;
    my $is_success = ($result && $result->{success}) ? 1 : 0;
    my $is_success_by_counter_id = { map { $_ => $is_success } keys %{ $self->uids_by_counter_id // {} } };
    return $is_success_by_counter_id;
}

__PACKAGE__->meta->make_immutable;

1;
