package JavaIntapi::UpdateShowConditions;

use Direct::Modern;
use Mouse;

use Yandex::Clone qw/yclone/;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:update_showconditions');
has '+warn_if_request_failed' => (default => 0);
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'client_id'    => (is => 'rw', isa => 'Id');

has '+items'        => (is => 'bare', init_arg => undef);
has 'keywords'      => (is => 'ro', isa => 'HashRef[HashRef]');
has 'retargetings'  => (is => 'ro', isa => 'HashRef[HashRef]');
has 'searchRetargetings' => (is => 'ro', isa => 'HashRef[HashRef]');
has 'targetInterests'  => (is => 'ro', isa => 'HashRef[HashRef]');
has 'relevanceMatches'  => (is => 'ro', isa => 'HashRef[HashRef]');
has 'adgroupType'   => (is => 'ro', isa => 'ArrayRef[Str]');
has 'copy_group_if_oversized' => (is => 'ro', isa => 'Bool', default => 0);

sub _method { 'showconditions/update' }

sub _get_url_params {
    my ($self) = @_;
    return {operator_uid => $self->operator_uid, client_id => $self->client_id};
}

sub _prepare {
    my ($self) = @_;

    my %result;

    my $keywords = $self->keywords;
    $result{keywords} = $self->_convert_to_java_model($keywords)  if $keywords && %$keywords;

    my $retargetings = $self->retargetings;
    $result{retargetings} = $self->_convert_to_java_model($retargetings)  if $retargetings && %$retargetings;

    my $search_retargetings = $self->searchRetargetings;
    $result{searchRetargetings} = $self->_convert_to_java_model($search_retargetings)  if $search_retargetings && %$search_retargetings;

    my $target_interests = $self->targetInterests;
    $result{targetInterests} = $self->_convert_to_java_model($target_interests)  if $target_interests && %$target_interests;

    my $relevance_matches = $self->relevanceMatches;
    $result{relevanceMatches} = $self->_convert_to_java_model($relevance_matches)  if $relevance_matches && %$relevance_matches;

    $result{adgroupType} = $self->_convert_to_java_model($self->adgroupType);

    $result{copy_group_if_oversized} = 1 if $self->copy_group_if_oversized;


    return \%result;
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ($result && %$result) {
        return $result;
    } else {
        die "error in call_intapi_java('showconditions/update'): " . ($error // '');
    }
}

sub _convert_to_java_model {
    my ($class, $objects) = @_;

    # copy frontend data
    my $result = yclone $objects;

    return $result;
}

__PACKAGE__->meta->make_immutable;

1;
