use warnings;
use strict;

=head NAME

LockTools -- простые функции про блокировку файлов

=head1 DESCRIPTION 

Ничего не знает про бизнес-логику и объекты Директа.
Не должен зависеть ни от чего в Директе, кроме Settings.

=cut

package LockTools;

use Fcntl ':flock';

use Settings;

use base qw/Exporter/;
our @EXPORT = qw(
    get_file_lock
    release_file_lock
);

############################
# Работа с блокировками
{
    my $lockname;
    my $lockpid;
    local *LOCK;
    # Попытаться залочить файл, если не получилось - сдохнуть от горя
    # NB: ".lock" добавляется к $filename автоматически!
    sub get_file_lock {
        my ($dont_die, $filename) = @_;
        die "Already locked" if $lockname;
        # определяем имя лок-файла
        if (!defined $filename) {
            die "Incorrect script name" unless $0 =~ /(\w+\.pl)$/;
            $filename = $1;
        } elsif ($filename !~ /^[a-z0-9\-\.\_]+$/i) {
            die "Incorrect lock file name: '$filename'";
        }
        $lockname = "$Settings::LOCK_ROOT/$filename.lock";
        open(LOCK, ">>", $lockname) or die("Can't open lockfile '$lockname': $!");
        my $seconds_after_modify = time() - (stat(LOCK))[9];
        unless(flock(LOCK, LOCK_EX | LOCK_NB)) {

            # не ругаемся или указаное кол-во секунд или 1 час (если ничего не указано) или 24 часа если указано 'DONT_DIE' до завершения предыдущей копии
            my $dont_die_before_seconds;
            if (defined $dont_die && $dont_die =~ /^[0-9]+$/ && $dont_die >= 0) {
                $dont_die_before_seconds = $dont_die;
            } elsif ($dont_die) {
                $dont_die_before_seconds = undef;
            } else {
                $dont_die_before_seconds = 3600;
            }
            
            if (! defined $dont_die_before_seconds || $seconds_after_modify < $dont_die_before_seconds) {
                # Ненулевой код возврата, чтобы отличить работал скрипт или нет
                exit 140;
            } else {
                die "Already running... $lockname skipped. (locked $seconds_after_modify seconds ago)\n";
            }
        }
        truncate LOCK, 0;
        print LOCK $$; # PID
        $lockpid = $$;
    }

    # Снять блокировку
    sub release_file_lock {
         return if !$lockname;
         if (defined $lockpid && $lockpid == $$) {
             # для форкающихся процессов блокировку с lock-файла снимает только тот, кто лочил
             flock(LOCK,LOCK_UN);
         }
         close LOCK;
         $lockname = undef;
         $lockpid = undef;
    }
}

1;
