package LogsCommander;


use strict;
use warnings;
use utf8;

use Fcntl qw/:flock/;
use List::MoreUtils qw/none/;


use Settings;
use Direct::ResponseHelper;

sub handler {
    my $r = shift;

    if ($r->method ne 'POST') {
        return [ 403 , ['Content-Type' => 'text/plain'], ['method not supported'] ];
    }

    my @idents = qw/dc-log-general dc3-stat-log dc-log-crash dc-log-usage/;
    if (none { $r->param($_) } @idents) {
        return [ 400, ['Content-Type' => 'text/plain'], ['missing ident'] ];
    }
    for my $ident (@idents) {
        my $param_value = $r->param($ident);
        next unless $param_value;

        #DIRECT-75813 - различать логи DC2 и DC3
        if ($ident eq 'dc-log-general' && $r->param($ident) !~ /^tskv\ttskv_format=dc-general-log/) {
            $param_value = $r->param($ident);
            $ident = 'dc3-stat-log';
        }
        my $log_file = "$Settings::DATA_ROOT/export/statbox/commander-$ident.log";
        open my $F, '>>', $log_file or return [ 500, ['Content-Type' => 'text/plain'], ['failed to open log file for append'] ];
        flock($F, LOCK_EX) or return [ 500, ['Content-Type' => 'text/plain'], ['failed to lock log file'] ];
        print {$F} $param_value;
        unless ($param_value =~ /\n$/) {
            print {$F} "\n";
        }
        flock($F, LOCK_UN);
        close $F;
    }

    return respond_text($r, "ok\n");
}

1;
