##################################################
#
#  Direct.Yandex.ru
#
#  MTools
#       Вспомогательные функции для работы с медийными банерами
#       Разработно для DoCmdMedia
#
#  $Id$
#
##################################################

=head1 NAME
    MTools



=head1 DESCRIPTION

Вспомогательные функции для работы с медийными банерами
Не путайте с медиапланами

=cut

package MTools;
## no critic (TestingAndDebugging::RequireUseStrict, TestingAndDebugging::RequireUseWarnings)

use Settings;
use Tools;
use HashingTools;

use YaCatalogApi;

use Yandex::DBTools;
use GeoTools;
use Yandex::I18n;
use Mcb qw/get_theme/;

use Yandex::HashUtils;
use Yandex::DateTime;
use Yandex::TimeCommon;
use Yandex::Validate qw/is_valid_date is_valid_int/;

use Data::Dumper;

use Hash::Util qw/lock_keys/;
use List::Util qw/reduce sum min/;
use List::MoreUtils qw/any all none uniq part pairwise/;
use Image::ExifTool qw/:Public/;
use YAML::Syck;
use Digest::MD5 qw(md5 md5_hex);
use Encode qw/is_utf8/;
use Primitives;
use URLDomain;
use LogTools qw/log_stacktrace/;

$Data::Dumper::Sortkeys = 1;

use utf8;

use strict;
use warnings;

use feature 'state';

require Exporter;

our $VERSION = '0.01';
our @ISA = qw(Exporter);
our @EXPORT = qw/
    true_mime
    media_content_type

    check_image
    get_media_file

    validate_camp_media_options

    media_content_type
    media_format
    media_format_by_id
    base_media_format

    get_media_group
    get_media_groups
    get_media_banner
    get_media_banners

    media_where_clause

    get_human_media_type

    calc_media_banner_status

    get_mcb_geo_min_shows
    get_mcb_prod_types

    get_min_month_media_shows

    $IS_ACTIVE_CLAUSE
    $IS_ACTIVE_MEDIA_CLAUSE
    $MCB_REGIONAL_EXCLUDE
    /;

our $DEBUG = 1;

#===========================  Constants  ==================================

# SQL для определения статуса баннера
# TODO: удалить $IS_ACTIVE_CLAUSE и пользоваться Models::AdGroupFilters::get_status_condition('active', filter)
our $IS_ACTIVE_CLAUSE = q{
    (
        -- Объявление и условия промодерированы (можно отправлять в БК)
        ph.statusPostModerate = 'Yes' AND b.statusPostModerate = 'Yes' AND (
            -- Для текстовых баннеров есть href или промодерированная визитка
            IF(b.banner_type = 'text', IFNULL(b.href,'') != '' OR b.phoneflag = 'Yes', 1)
        ) OR
        -- Или выставлен статус активности
        b.statusActive = 'Yes'
    ) AND
    -- Клиент не остановил баннер
    b.statusShow = 'Yes'
};
our $IS_ACTIVE_MEDIA_CLAUSE = qq| ( g.statusModerate='Yes' AND b.statusModerate='Yes'  OR  b.statusActive='Yes' ) AND b.statusShow='Yes' |;

# максимальная длина ссылки медийного баннера
our $MAX_MEDIA_URL_LENGTH = 255;

#   init allowed media_banner sizes(formats)
our %MEDIA_FORMATS=();
our %MEDIA_FORMATS_BY_ID=();
our %BASE_MEDIA_FORMAT = ( default => {width=>200, height=>300},
                           turkish => {width=>200, height=>300} );

#   Content-types for HTTP headers
our %MEDIA_CONTENT_TYPE = (
    JPG     =>  'image/jpeg',
    JPEG    =>  'image/jpeg',
    PNG     =>  'image/png',
    GIF     =>  'image/gif',
    SWF     =>  'application/x-shockwave-flash',
    CWS     =>  'application/x-shockwave-flash',
);

#   Соответствие значений, возвращаемых внешними библиотеками значениям в базе
our %TRUE_MIMES = (
    JPG     =>  'JPG',
    JPEG    =>  'JPG',
    PNG     =>  'PNG',
    GIF     =>  'GIF',
    SWF     =>  'SWF',
    CWS     =>  'SWF',
);

our %MEDIA_TYPE_HUMAN = (
    mcb             => iget_noop('МКБ'),
    anticontext     => iget_noop('Гео таргетинг'),
    geo             => iget_noop('Гео таргетинг'),
    text            => iget_noop('Директ'),
    wallet          => iget_noop('Общий счет'),
    mcb_pkg         => iget_noop('МКБ пакет'),
    mcb_regional    => iget_noop('МКБ региональный'),
    mcb_turkish     => iget_noop('МКБ турецкий'),
    cpm_banner      => iget_noop('Директ'),
    cpm_deals       => iget_noop('Директ'),
    cpm_yndx_frontpage  => iget_noop('Директ'),
);

our $MCB_REGIONAL_EXCLUDE = [1, 10174]; # Московская и Ленинградская области

our %MCB_PRICE_FOR_CURRENCY = (
    TRY => 21.0,    # лир за 1000 показов
);

our $MTOOLS_INITIALIZED=0;

#init_constants();

sub init_constants{
    return if $MTOOLS_INITIALIZED++;

    my $formats = get_all_sql(PPCDICT, "SELECT format_id, width, height, max_size, enabled FROM media_formats");

    for my $row (@$formats) {
        $MEDIA_FORMATS{ sprintf "%dx%d", $row->{width}, $row->{height} } =  $row->{format_id};
        $MEDIA_FORMATS_BY_ID{ $row->{format_id} } = hash_cut $row, qw/width height max_size enabled/;
    }

    my $base_media_format_ok = 1;
    if (%BASE_MEDIA_FORMAT) {
        for my $key (keys %BASE_MEDIA_FORMAT) {
            my $format = $BASE_MEDIA_FORMAT{$key};
            if ((2 != scalar grep {$_} @{ $format }{qw/width height/}) || !defined $MEDIA_FORMATS{sprintf "%dx%d", @{ $format }{qw/width height/}}) {
                $base_media_format_ok = 0;
                last;
            }
        }
    } else {
        $base_media_format_ok = 0;
    }
    die "BASE_MEDIA_FORMAT is not defined in media_formats" unless $base_media_format_ok;
}

sub media_format {
    init_constants();
    my ($w,$h,$use_disabled) = @_;
    return undef unless defined $w and defined $h;
    my $res = $MEDIA_FORMATS{ sprintf "%dx%d", $w, $h } or return undef;
    return ($use_disabled || $MEDIA_FORMATS_BY_ID{$res}{enabled} eq 'Yes') ? $res : undef;
}

sub media_format_by_id {
    init_constants();
    my $id = shift or return undef;
    my $use_disabled = shift;
    my $res = $MEDIA_FORMATS_BY_ID{ $id };
    return ($use_disabled || $res->{enabled} eq 'Yes') ? $res : undef;
}

sub base_media_format {
    my %O = @_;
    init_constants();
    return unless $O{product_type} || $O{cid};
    state %product_type_by_cid;
    my $format_hash;
    if ($O{cid}) {
        $product_type_by_cid{$O{cid}} ||= product_info(cid => $O{cid})->{product_type};
    }
    my $product_type = $O{product_type} || $product_type_by_cid{$O{cid}};
    $format_hash = $BASE_MEDIA_FORMAT{ is_turkish_mcb($product_type) ? 'turkish' : 'default' };
    return $MEDIA_FORMATS{ sprintf "%dx%d", @{ $format_hash }{qw/width height/} };
}

sub true_mime {
    init_constants();
    my $mime = shift;
    return $TRUE_MIMES{uc $mime};
}

sub media_content_type {
    init_constants();
    my $mime = shift;
    return $MEDIA_CONTENT_TYPE{uc $mime};
}

sub get_human_media_type($){
    my $mediaType = shift || return undef;
    return $MEDIA_TYPE_HUMAN{lc $mediaType};
}

## functions for Tools or Common

#   determine image size, file format (is it valid picture)
sub check_image{
    my ($data)=@_;

    # NB: md5_base64ya на русских текстах падает. 
    # В норме в $data бинарная картинка, но при ошибочном url может оказаться и просто html. 
    # Поэтому принудительно кодируем $data. 
    # Возможно, можно это делать прямо в md5_base64ya
    my $encoded_data = Encode::is_utf8($data) ? Encode::encode_utf8($data) : $data;
    my $md5 = md5_base64ya($encoded_data);

    my $iinfo = eval { ImageInfo(\$data) };
    if ($@) {
        # ImageInfo падает на некоторых не-flash файлах
        return { error => iget("Неверный формат файла") };
    }

    my $res = {
        width       => $iinfo->{ImageWidth},
        height      => $iinfo->{ImageHeight},
        format_id   => media_format($iinfo->{ImageWidth}, $iinfo->{ImageHeight}),
        mime        => true_mime($iinfo->{FileType}),
        contentType => $iinfo->{MIMEType},
        md5         => $md5,
        size        => length($data),
        img         => $data,
    };
    $res->{error} = $iinfo->{error} if defined $iinfo->{error};

    hash_merge $res, hash_kgrep {m/^Flash/} $iinfo if ($iinfo->{FileType}||'') =~ m/^(swf|cws)$/i;

    $res->{FlashVersion} ||= $iinfo->{SWF_FileVersion};

    return $res;
}

#   Media Campaign functions

sub validate_camp_media_options{
    my ($c, $uid, $is_new_camp) = @_;

    if (!is_package_mcb($c->{product_type})) {
        # DIRECT-23102 закрасить МКБ в РСЯ - убрана проверка rf/rfReset
    }
    if ($c->{autobudget} && $c->{autobudget} eq 'Yes'
        && $c->{start_date}      && is_valid_date($c->{start_date})
        && $c->{autobudget_date} && is_valid_date($c->{autobudget_date})
        && ts_round_day(mysql2unix($c->{autobudget_date})) <= ts_round_day(mysql2unix($c->{start_time}))) {
        return iget('Дата окончания показов не может быть меньше даты начала');
    }

    return;
}

#   Media Banner Group functions

sub get_media_group {return (get_media_groups(@_), undef)[0]}
sub get_media_groups{
    log_stacktrace("mcb", 'get_media_groups');
    my ($mgid, $cid, $OrderID, $no_banners, $mediaType, $has_BannerID, $tab, $translocal_params) = @{$_[0]}{qw/mgid cid OrderID no_banners mediaType has_BannerID tab translocal_params/};

    my $ppc_shard;
    my $groups;
    if ( defined $cid || defined $OrderID ) {

        my $name = (defined $OrderID) ? 'OrderID' : 'cid';
        my $id   = (defined $OrderID) ? $OrderID  : $cid ;
        $ppc_shard = PPC($name => $id);

        $groups = get_all_sql($ppc_shard,
            $mediaType ? 
            "SELECT g.mgid, g.cid, g.geo, g.mcb_theme_id, g.statusModerate, g.mcbPhrasesChanged, g.categories,
                    (select sum(bs.shows ) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as shows,
                    (select sum(bs.clicks) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as clicks,
                    g.last_month_shows
               FROM media_groups g
              WHERE $name = ?
           ORDER BY g.mgid"
            :
            "SELECT g.mgid, g.cid, g.geo, mcb_theme_id, c.type as mediaType, c.OrderID, g.statusModerate, g.mcbPhrasesChanged, g.categories,
                    (select sum(bs.shows ) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as shows,
                    (select sum(bs.clicks) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as clicks,
                    g.last_month_shows, c.ProductID
               FROM media_groups g
               JOIN campaigns c ON c.cid=g.cid
              WHERE g.$name = ?
           ORDER BY g.mgid"
                    , $id);

    } elsif ( defined $mgid and ref $mgid eq 'ARRAY' and scalar @$mgid or $mgid =~ m/^\d+$/ ) {
        $ppc_shard = PPC(pid => $mgid);
        my $mgids = join(",", @{ref $mgid eq 'ARRAY' ? $mgid : [$mgid]});
        $groups = get_all_sql($ppc_shard,
            $mediaType ? 
            "SELECT g.mgid, g.cid, g.geo, g.mcb_theme_id, g.statusModerate, g.mcbPhrasesChanged, g.categories,
                    (select sum(bs.shows ) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as shows,
                    (select sum(bs.clicks) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as clicks,
                    g.last_month_shows
               FROM media_groups g
              WHERE mgid IN ($mgids)"
            :
            "SELECT g.mgid, g.cid, g.geo, mcb_theme_id, c.type as mediaType, g.statusModerate, g.mcbPhrasesChanged, g.categories,
                    (select sum(bs.shows ) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as shows,
                    (select sum(bs.clicks) from media_banners b LEFT JOIN bs_media_stat bs USING(BannerID) where b.mgid=g.mgid ) as clicks,
                    g.last_month_shows, c.ProductID
               FROM media_groups g
               JOIN campaigns c ON c.cid=g.cid
              WHERE g.mgid IN ($mgids)"
                );

    } else {
        return;
    }
    return unless scalar @$groups;

    for my $g (@$groups) {
        # product_info смотрит сначала на ProductID, а если он пустой - на cid
        $g->{product_type} = product_info(ProductID => $g->{ProductID}, cid => $g->{cid})->{product_type};

        $g->{ctr} = $g->{shows} ? ($g->{clicks}/$g->{shows}) : 0;

        $g->{declined} = 1 if $g->{statusModerate} eq 'No';
        $g->{mediaType} ||= $mediaType;
        $g->{mediaTypeHuman} = get_human_media_type($g->{product_type});

        if ($translocal_params) {
            $g->{geo} = GeoTools::modify_translocal_region_before_show(
                GeoTools::refine_geoid($g->{geo}, undef, $translocal_params),
                $translocal_params,
            );
        }
        $g->{geo_name} = get_geo_names( $g->{geo}, "\n" );

        
        $g->{categories_names} = [map { get_category_name($_)} split(/\s*\,\s*/, ($g->{categories}||'')) ];

        $g->{mcb_theme} = get_theme($g->{mcb_theme_id});

        if ( lc $g->{mediaType} eq qq/mcb/) {
            $g->{mcb_phrases} = get_all_sql($ppc_shard, qq!
                SELECT id, mgid, phrase, norm_hash, month_shows, month_shows as showsForecast
                  FROM mcb_phrases
                 WHERE mgid=?
              ORDER BY id
                    !, $g->{mgid})||[];
        } elsif (lc $g->{mediaType} eq qq/socdem/) {
            die "DIRECT-91407: mediaType = socdem should not exist";
        }

        unless ( $no_banners ) {
            $g->{banners} = [ get_media_banners({mgid=>$g->{mgid}, tab => $tab}) ];

            # вычисляем статусы условия
            my @banners_status = get_media_banners_status({mgid=>$g->{mgid}});
            $g->{declined_cnt} = grep {$_->{statusModerate} eq 'No'} @banners_status;
            $g->{canDelete} = none {$_->{BannerID}} @banners_status;
            $g->{statusShow} = any {$_->{statusShow} eq 'Yes'} @banners_status;
            $g->{statusArch} = all {$_->{statusArch} eq 'Yes'} @banners_status;
            $g->{declined} ||= $g->{declined_cnt};

            # и возможные действия
            $g->{canArchive} = (all {$_->{statusShow} eq 'No' || !$_->{BannerID}} @banners_status)
                && (any {$_->{statusArch} eq 'No'} @banners_status);
            if (is_package_mcb($g->{product_type})) {
                my $active_banners = scalar(grep { 
                        $_->{statusArch}     eq 'No'
                     && $_->{statusModerate} eq 'Yes'
                     && $_->{statusShow}     eq 'Yes'}
                @banners_status);
                # Не разрешаем архивировать последний активный баннер
                if ($active_banners == 1) {
                    $_->{canArchive} = 0 for @{$g->{banners}};
                }
                # если есть активные баннеры - прячем ссылку 'Заархивировать все баннеры'
                if ($active_banners > 0) {
                    $g->{canArchive} = 0;
                }

            }
            $g->{canUnArchive} = all {$_->{statusArch} eq 'Yes'} @banners_status;

            $g->{canResume} = (none {$_->{statusShow} eq 'Yes'} @banners_status)
                && (any {$_->{statusModerate} eq 'Yes'
                         && $_->{statusArch} eq 'No'
                         && $_->{format_id} == base_media_format(product_type => $g->{product_type})
                        } @banners_status);
            $g->{canStop} = any {$_->{statusShow} eq 'Yes'} @banners_status;

            # вычисляем текстовые описания статусов баннеров
            $_->{statusBanner} = calc_media_banner_status($_, $g) for @{$g->{banners}};
        }
    }

    return @$groups;
}

sub calc_media_banner_status
{
    ## no critic (Freenode::DollarAB)
    my ($b, $g) = @_;

    my @status;
    if ($b->{statusArch} eq 'Yes') {
        push @status, iget('Баннер заархивирован');
    } else {

        if ($b->{statusModerate} eq 'Yes') {
            if ($g->{statusModerate} eq 'Yes') {
                if ($b->{statusShow} eq 'Yes') {
                    if ($b->{statusBsSynced} eq 'Yes') {
                        push @status, iget('Работает');
                    } else {
                        push @status, iget('Идет активизация');
                    }
                } else {
                    push @status, iget('Баннер остановлен');
                }
            } elsif ($g->{statusModerate} eq 'No') {
                push @status, iget('Условие отклонено');
            } elsif ($g->{statusModerate} =~ /^(Ready|Sent)$/) {
                push @status, iget('Условие на модерации');
            } else {
#                warn "Bad media_group statusModerate: $g->{statusModerate}";
                @status=(iget('Черновик'));
            }
        } elsif ($b->{statusModerate} =~ /^(Ready|Sent)$/) {
            push @status, iget('Баннер на модерации');
        } elsif ($b->{statusModerate} eq 'New') {
            @status=(iget('Черновик'));
        } elsif ($b->{statusModerate} eq 'No') {
            push @status, iget('Баннер отклонен');
        } else {
#            warn "Bad media_benner statusModerate: $b->{statusModerate}";
            @status=(iget('Черновик'));
        }
    }

    return \@status;
}

our %MEDIA_TAB_CLAUSE = (
        'wait'      =>  qq| AND (g.statusModerate in ('Ready', 'Sent') OR b.statusModerate in ('Ready', 'Sent')) AND b.statusArch='No'|,
        'arch'      =>  qq| AND b.statusArch='Yes'|,
        'off'       =>  qq| AND b.statusShow='No' AND b.statusArch='No'|,
        'active'    =>  qq| AND $IS_ACTIVE_MEDIA_CLAUSE|,
        'decline'   =>  qq| AND (b.statusModerate='No' OR g.statusModerate='No') AND b.statusArch = 'No'|,
        'draft'     =>  qq| AND b.statusModerate = 'New' AND g.statusModerate = 'New' AND b.statusArch = 'No'|, 
        'all'       =>  qq| AND 1|,
    );

#   Media Banner functions
sub get_media_banners_status {
    my ($cond) = @_;
    my $WHERE = media_where_clause(hash_cut $cond, qw/mbid mgid BannerID/);
    return () if !$WHERE;
    my $ppc_shard = media_ppc_shard(hash_cut $cond, qw/mbid mgid BannerID/) or return;
    return map {lock_keys(%$_); $_}
           @{get_all_sql($ppc_shard, "
            SELECT b.mgid, b.mbid, b.BannerID, b.format_id
                 , b.statusShow, b.statusArch, b.statusModerate, b.statusActive
                 , IF($IS_ACTIVE_MEDIA_CLAUSE, 1, 0) as is_active
                 , IF(b.statusShow = 'Yes', 1, 0) is_potential_active
              FROM media_banners b
              JOIN media_groups g USING(mgid)
             WHERE $WHERE
            ")};
}

sub get_media_banner {return (get_media_banners(@_), undef)[0]};
sub get_media_banners{
    log_stacktrace("mcb", 'get_media_banners');
    my ($mbid, $mgid, $BannerID, $OrderID, $tab) = @{$_[0]}{qw/mbid mgid BannerID OrderID tab/};

    my $to_where = media_where_clause(hash_cut $_[0], qw/mbid mgid BannerID/) or return;

    $to_where .= $MEDIA_TAB_CLAUSE{$tab||''}||'';

    my $ppc_shard = $OrderID ? PPC(OrderID => $OrderID) : media_ppc_shard(hash_cut $_[0], qw/mbid mgid BannerID OrderID/) || return;
    my $banners = get_all_sql($ppc_shard, "
         SELECT b.mbid, b.mgid, b.alt, b.name,
                b.href, b.domain, b.reverse_domain,
                b.flash_href, b.counter_href,
                b.md5_flash, b.md5_picture,
                b.name_flash, b.name_picture,
                b.BannerID, b.LastChange, DATE_FORMAT(b.LastChange, '%H:%i:%s %d.%m.%Y') as LastChangeHuman,
                b.statusModerate, b.statusArch, b.statusShow, b.statusBsSynced,
                bs.shows, bs.clicks, IF(bs.shows, bs.clicks/bs.shows, NULL) as ctr,
                g.cid
           FROM media_banners b
      LEFT JOIN media_groups g USING(mgid)
      LEFT JOIN bs_media_stat bs USING(BannerID)
          WHERE $to_where"
            );

    # получаем все базовый баннеры из нужных групп
    my @all_banners;
    if (@$banners) {
        my @mgids = uniq map {$_->{mgid}} @$banners;
        @all_banners = get_media_banners_status({mgid => \@mgids});
    }

    ## no critic (Freenode::DollarAB)
    for my $b (@$banners) {
        for (qw/flash picture/) {
            next unless $b->{"md5_$_"};
            $b->{$_} = get_media_file($b->{"md5_$_"});
            hash_merge $b, hash_grep {defined $_} hash_cut $b->{$_}, qw/width height format_id format /;
        }

        my $base_media_format_id = base_media_format(cid => $b->{cid});
        if ( $b->{picture} ) {
            $b->{format_id} = $b->{picture}{format_id};
            $b->{is_base_banner} = ( ($b->{format_id} || 0) eq $base_media_format_id) ? 1 : 0;
            $b->{is_horizontal} = ( $b->{width} > $b->{height})?1:0;
        }
        
        # прописываем вычисляемые флаги
        # все баннеры группы, кроме текущего
        my @other_banners = grep {$_->{mgid}==$b->{mgid} && $_->{mbid}!=$b->{mbid}} @all_banners;
        my $other_active_base_banners = grep {$_->{is_active} && $_->{format_id} == $base_media_format_id} @other_banners;
        my $other_active_banners = grep {$_->{is_active}} @other_banners;
        my $other_potential_active_banners = grep {$_->{is_potential_active}} @other_banners;
        #print STDERR "$b->{mbid} - other_active_base_banners: $other_active_base_banners, other_active_banners: $other_active_banners, other_potential_active_banners: $other_potential_active_banners\n";
        # можно ли его запустить
        $b->{canResume} = $b->{statusShow} eq 'No' && $b->{statusModerate} eq 'Yes'
                    && $b->{statusArch} eq 'No'
                    && ( $b->{format_id} == $base_media_format_id || $other_active_base_banners );
        # можно ли его остановить
        $b->{canStop} = $b->{statusShow} eq 'Yes'
                    && ( $b->{format_id} != $base_media_format_id || $other_active_base_banners || !$other_potential_active_banners);
        # можно ли архивировать
        $b->{canArchive} = $b->{statusArch} eq 'No' && ($b->{statusShow} eq 'No' || !$b->{BannerID});
        # можно ли разархивировать
        $b->{canUnArchive} = $b->{statusArch} eq 'Yes';
        $b->{href} = clear_banner_href($b->{href});
    }
    return @$banners;
}

#   Get storege info for file_md5 if such file exists, either return undef
#   This function dosn't get the file itself
sub get_media_file{
    my $md5 = shift or return undef;

    my $vars = get_one_line_sql(PPCDICT,
                 "SELECT md5, md5 as image_hash, mds_group_id, avatars_host, format_id, mime, size, LastChange
                    FROM media_files
                   WHERE md5=?",
                         $md5) or return undef;
    $vars->{md5} = $md5;
    hash_merge $vars, media_format_by_id($vars->{format_id}, 1);   #   put width and height into vars
    $vars->{contentType} = media_content_type($vars->{mime});
    $vars->{url} = get_media_file_url($vars, $vars->{mime});

    return $vars;
}

#
#   Получить адрес картинки/flash-ролика МКБ в Директе
#

sub get_media_file_url{
    my ($image, $mime) = @_;

    my $extension = lc $mime;
    $extension = 'jpg' if $extension eq 'jpeg';

    return "$Settings::IMAGE_HOST/" . ($image->{mds_group_id} ? "$image->{mds_group_id}/" : "") . "$image->{image_hash}.$extension";
}

#
#   Construct where clause for media_banner (selection|modification) requests
#
sub media_where {
    my $vars = $_[0];

    my $to_where = undef;
    my ($key) = grep { defined $vars->{$_} } qw/mgid mbid BannerID cid/;
    return undef unless $key and (ref $vars->{$key}) =~ m/^(|ARRAY)$/ ;

    my @values = grep {m/^\d+$/}
                map {s/^\s*|\s*$//g; $_}
                (ref $vars->{$key}) ? (@{$vars->{$key}}) : (split /\s*\,\s*/, $vars->{$key});
    return undef unless scalar @values;

    return $key, \@values;
}
# кусок SQL для WHERE, проверяющая принадлежность баннера к выборке
sub media_where_clause {
    my ($key, $values) = media_where(@_);
    return undef if !defined $key;
    return "g.$key in (".join(',', @$values).')' if $key =~ m/^(cid)$/;
    return "b.$key in (".join(',', @$values).')';
}

sub media_ppc_shard {
    my ($key, $values) = media_where(@_);

    return undef if !defined $key;
    return PPC(($key eq 'mgid' ? 'pid' : $key) => $values);
}

=head2 get_mcb_geo_min_shows([@targetings], {ClientID => 12345, product_type => 'mcb'})

    По таргетингу и типу продукта получить мин платёж для МКБ кампании

=cut

sub get_mcb_geo_min_shows($$) {

    my ($targetings, $opt) = @_;

    my @all_geo_childs = uniq map {get_geo_children($_, $opt)} @$targetings;

    my ($min_shows, $targ_region);
    if (is_turkish_mcb($opt->{product_type})) {
        # для турецкого МКБ одинаковый минимальный заказ во всех регионах (пока что)
        $min_shows = 250_000;
    } else {
        if (!@all_geo_childs || grep {$_ == 213} @all_geo_childs) {
            # Москва
            $min_shows = 50_000;
            $targ_region = 'moscow';
        } elsif (grep {$_ == 2} @all_geo_childs) {
            # Питер
            $min_shows = 20_000;
            $targ_region = 'north-west';
        } else {
            # Всё остальное
            $min_shows = 10_000;
        }
    }

    return wantarray ? ($min_shows, $targ_region) : $min_shows;
}


=head2 get_mcb_prod_types

Получить список типов продуктов для МКБ:

 ( { name => 'prod_name', type => 'prod_type' },) 

=cut 

sub get_mcb_prod_types
{  
    return get_all_sql(PPCDICT,qq#
        SELECT type, product_name as name
          FROM products
         WHERE type IN ('mcb', 'mcb_regional', 'mcb_turkish')
      GROUP BY type, product_name
      #);
}

# --------------------------------------------------------------------

=head2 get_min_month_media_shows

    Получить минимальное количество показов в месяц для медийной кампании (зависит от типа продукта)

=cut

sub get_min_month_media_shows {
    my %O = @_;
    my $product_type = $O{product_type} || product_info(cid => $O{cid})->{product_type};
    return is_turkish_mcb($product_type) ? $Settings::MIN_MONTH_MEDIA_SHOWS_FOR_TURKEY : $Settings::MIN_MONTH_MEDIA_SHOWS;
}

1;

=head1 SEE ALSO

    DoCmdMedia

=cut
