#######################################################################
#
#  Direct.Yandex.ru
#
#  MailService
#  send mails and other
#
#  $Id$
#
#######################################################################

=head1 NAME

MailService - send mails and other

=head1 DESCRIPTION

send mails and other

=head1 FUNCTIONS


=cut

package MailService;

use Direct::Modern;

use Encode;
use Date::Calc;
use Digest::HMAC_MD5;
use List::Util qw/first/;
use List::MoreUtils qw/any none uniq/;

use User;
use Client qw/is_send_sms_despite_sms_flags_for_new_wallet_warnings_client is_new_wallet_warnings_client/;
use Settings;
use Tools;
use LogTools qw//;
use TextTools;
use TTTools();
use Fcntl ':flock';
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::TimeCommon;
use Template;
use Yandex::Template::Provider::Encoded;
use MIME::Base64 qw(encode_base64);
use MIME::Lite;
use MIME::Types;
require Email::Date::Format;
use Data::Dumper;
use POSIX qw(strftime);
use File::Slurp;
use RBACDirect;
use Currency::Format;
use Currency::Rate;
use Currency::Texts;
use Currencies;
use PrimitivesIds;
use Primitives;
use geo_regions;
use GeoTools;
use CampaignQuery;
use MailNotification qw();

use Yandex::HashUtils;
use Yandex::SendMail qw(send_alert sendmail call_sendmail extract_email extract_headers yservice_headers);
use Yandex::SendSMS;
use Yandex::IDN qw/is_valid_email/;
use Yandex::MailTemplate;
use Yandex::I18n;
use Yandex::Validate;

use utf8;

require Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw(
    sendmail_with_logging
    sendmail_attach
    send_prepared_mail
    send_prepared_sms
    process_sms_queue
    expire_old_sms_in_queue
    send_die_letters
);
our $OTRS_ROBOT_EMAIL = 'robot-tcrm-dev@yandex-team.ru';
our $OTRS_SIGN_SALT = 'f57f1e5c4431464d7537f1e3ebe2a88ed10658a8351eec4d03e776f3000113393dad7dc04da56d341e29004c12e90d7b07c824292f45cbe5f37176c82a006f4a';

=head2 $SMS_EXPIRE_TIME

    Время устаревания смс-сообщений в очреди (в секундах)
    По-умолчанию - сутки

=cut
our $SMS_EXPIRE_TIME ||= 24 * 3600;

my $LOG = "$Settings::LOG_ROOT/sendmail.";



our %OTRS_TICKET_EMAIL = (
    # если документы добавляются на сервисируемую кампанию, то отсылать их на эти адреса
    manager => 'docs-modclaim@yandex-team.ru',
    manager_tr => 'reklam-destek@yandex-team.com.tr',
    # если документы добавляются на агентсткую кампанию, и это агентство не самоходное (см %User::SPECIAL_MANAGER_UID), то отсылаем на эти адреса
    agency => 'mod-vip@yandex-team.ru',
    agency_ua => 'mod-agency@support.yandex.ua',
    # если документы добавляются на кампанию без агентства, то отсылать на эти адреса
    self => 'client-service@yandex-team.ru',
    self_ua => 'client-service@yandex-team.com.ua',
    self_tr => 'direct@destek.yandex.com.tr',
    self_cis => 'sngmod-agency@support.yandex.ru',
    # если документы добавляются на кампанию самоходного агентства, то отсылать на эти адреса
    self_agency => 'agency-service@yandex-team.ru',
    self_agency_ua => 'client-service@yandex-team.com.ua',
    self_agency_tr => 'direct@destek.yandex.com.tr',
    self_agency_cis => 'sngmod-agency@support.yandex.ru',
);

# Шаблоны СMC, которые отправляем всегда
my @SERVICE_SMS = qw/
    autopay_error_not_enough_funds_sms
    autopay_error_expired_card_sms
    autopay_error_other_sms
    active_orders_money_out_reminder_sms
/;

#======================================================================

=head1 sendmail_attach

 send mail with attaches across sendmail

 sendmail_attach($email, $from, $subj, $content, $attaches_arr_ref);
   
   # see MIME::Lite->attach()
   $attaches_arrref = [
     {
        Type     => 'application/vnd.ms-excel',
        Filename => 'report.xls',
        Data     => 'xls data',
        # or
        Path     => 'filepath/file',
     },
     {...},
   ];

=cut

sub sendmail_attach
{
    my ($email, $from, $subj, $content, $attaches, %O) = @_;

    my ($to, $cc, $bcc) = extract_email($email);

    my %mail_set = (
        From    => Encode::encode_utf8($from),
        Subject => Encode::encode_utf8('=?koi8-r?B?'.encode_base64(Encode::encode('koi8-r', $subj), '').'?='),
        To      => Encode::encode_utf8($to),
        Type => Encode::encode_utf8('text/plain; charset=koi8-r'),
        Encoding => Encode::encode_utf8('base64'),
        Data => Encode::encode('koi8-r', $content),
        extract_headers($email),
    );
    $mail_set{CC} = $cc if $cc;
    $mail_set{BCC} = $bcc if $bcc;
    # Добавляем заголовки, нужные для поддержки X-YService
    hash_merge \%mail_set, yservice_headers({%mail_set, PlainSubject => $subj});

    my $msg = MIME::Lite->new(%mail_set);

    if (ref($attaches) eq 'ARRAY' && @$attaches) {

        for my $attach (@$attaches) {
            $msg->attach(%$attach);
        }
        
    }

    if ($O{empty_disposition}) {
        foreach my $part (@{$msg->{Parts}}) {
            # удаляем Content-Disposition из заголовка
            # нужно для jira, которая получив сообщение - вставила текст в description тикета, иначе считает его приложением к письму
            $part->attr("Content-Disposition" => "") if $part->attr('Content-Disposition') eq 'inline';
        }
    }
    
    #warn Dumper {msg => $msg};
    #warn "MSG:".$msg->as_string();
    
    call_sendmail($msg->as_string());

    # logging
    if ($to ne 'ppc-admin@yandex-team.ru') { # not log from send_alert
        LogTools::log_mail($to, '', $subj, '', $O{client_id});

        local *F;
        if (open F, ">>:encoding(utf8)", $LOG.strftime("%Y%m%d", localtime())) {
            printf F "%s\t%s\t%s\n", strftime("%Y%m%d\t%T", localtime()), $to, $subj;
            close F;
        } else {
            warn "Error logging sendmail: $!";
            return;
        }
    }
}


#======================================================================

=head1 send_prepared_mail

send mail from template

 send_prepared_mail($tt_name, $email_or_uid, $from, $vars, $send_to_reps, 0, use_send_warn => 1);
 use_send_warn - смотреть на sendWarn на клиенте или на кампании

 $send_to_reps - флаг, что письмо клиенту и нужно послать копию на email кампании и отдельно для каждого представителя
 может содержать имя ключа в $vars для ФИО, если в шаблоне письма нет переменной fio_var_name

 если в хеше $vars есть ключ sendWarn, то:
   - учитываем его при посылке письма на основной адрес (должно быть 'Yes'),
   - и одновременно смотрим значение sendWarn в кампании (если есть отсылка писем для кампании), тоже должно быть 'Yes'

 return count of sended emails

=cut

sub send_prepared_mail
{
    my ($tt_name, $email_or_uid, $FROM, $vars, $send_to_reps, $not_logging_flag, %OPT) = @_;

    my %sent_emails;
    my ($email, $uid, $sendWarn, $FIO);
    my $lang = Yandex::I18n::default_lang(); # 'ru'

    if ( defined( $email_or_uid ) && ref($email_or_uid) eq '' && $email_or_uid =~ /^\d+$/) {
        # is uid
        $uid = $email_or_uid;
    } elsif (ref($email_or_uid) eq 'HASH' && $email_or_uid->{uid}) {
        # is hashref with defined 'uid' field
        $uid = $email_or_uid->{uid};
    } else {
        # is email or hashref with 'to' field and other not mandatory fields like 'bcc', 'cc', 'reply_to'
        $email = $email_or_uid;
    }

    my $dyn_predefine = {
        direct_tld => 'ru',
        lang => 'ru'
    };
    if (!$email) {
        my $user_data = get_one_line_sql(PPC(uid => $uid), "
                                    SELECT u.email, u.lang, u.sendWarn, u.FIO
                                         , cl.country_region_id, co.is_ya_agency_client
                                      FROM users u
                                           LEFT JOIN clients cl on cl.ClientID = u.ClientID
                                           LEFT JOIN clients_options co on cl.ClientID = co.ClientID
                                     WHERE u.uid = ?", $uid);
        return 0 if $user_data->{is_ya_agency_client};
        $dyn_predefine = _make_dyn_predefine($user_data);
        $email = $user_data->{email};
        $lang = $user_data->{lang};
        $FIO = $user_data->{FIO};
        $sendWarn = $OPT{use_send_warn} ? $user_data->{sendWarn} : undef;
        if (ref($email_or_uid) eq 'HASH') {
            $email = hash_merge $email_or_uid, {to => $email};
        }
    }

    my $from;
    if($FROM eq $Settings::NOTIFICATION_EMAIL_FROM){
        $from = {
            name => 'Yandex.Direct',
            email => $Settings::DEFAULT_FROM_FIELD_DEPENDING_ON_LANG->{$lang},
        };
    } else {
        $from = $FROM;
    }

    return 0 unless $email;

    my ($mail_subj, $mail_body) = _compile_mail_from_template($tt_name, $lang, $vars, 
                                                              rep_fio => $FIO, fio_var_name => $send_to_reps,
                                                              dyn_predefine => $dyn_predefine);
    $email =~ s/\s//g if ref($email) eq '';

    if (defined $mail_body
        && defined $mail_subj
        && (! $OPT{use_send_warn} || (defined $sendWarn && $sendWarn eq 'Yes'))
        && (ref($email) eq 'HASH' || is_valid_email($email))
       )
    {
        sendmail_with_logging($email, $from, $mail_subj, \$mail_body, 'text', $not_logging_flag, $tt_name, $vars->{client_id});
        my $recipient_address = ref($email) eq 'HASH' ? $email->{to} : $email;
        $sent_emails{lc($recipient_address)} = 1;
    }

    return scalar(keys(%sent_emails)) unless $send_to_reps;

    my $camp_email = {};
    # to email on camp
    if (defined $vars->{cid} && $vars->{cid} =~ /^\d+$/) {

        $camp_email = get_one_line_sql(
            PPC(cid => $vars->{cid}), q/
                SELECT co.email, u.FIO, co.valid, co.sendWarn, c.uid
                     , cl.country_region_id
                  FROM camp_options co
                       JOIN campaigns c on c.cid = co.cid
                       JOIN users u on u.uid = c.uid
                       LEFT JOIN clients cl on cl.ClientID = u.ClientID
                 WHERE co.cid = ?
                       AND co.valid = 2
            /, $vars->{cid}
        ) || {};
        $camp_email->{lang} = $lang;
    }

    # get emails of all reps of client
    my $uids_for_rep_emails = $uid || $camp_email->{uid};
    if ($uids_for_rep_emails) {
        my $freelancers_uid = RBACDirect::rbac_get_uid_of_related_freelancer(undef, $uids_for_rep_emails);
        $uids_for_rep_emails = [$uids_for_rep_emails, $freelancers_uid ? $freelancers_uid : ()];
    }
    $uids_for_rep_emails //= [];

    my $rep_emails = @$uids_for_rep_emails
                     ? get_all_sql(PPC(uid => $uids_for_rep_emails), [q/
                            SELECT u.email, u.FIO, u.sendWarn, u.lang
                                 , cl.country_region_id
                              FROM users u
                                   LEFT JOIN users_options uo on uo.uid = u.uid
                                   LEFT JOIN clients cl on cl.ClientID = u.ClientID
                             /,
                             WHERE => {
                                'u.ClientID' => get_clientids(uid => $uids_for_rep_emails),
                                'uo.sendClientLetters'  => 'Yes'
                             }])
                     : [];

    for my $rep_email_row ($camp_email, @$rep_emails) {
        my $rep_email = $rep_email_row->{email};
        next if ! defined $rep_email;
        $rep_email =~ s/\s//g;
        next if ! is_valid_email($rep_email);
        next if $OPT{use_send_warn} && $rep_email_row->{sendWarn} eq 'No'; # если посылаем предупреждения о позициях и в параметрах выключены такие предупреждения
        next if $sent_emails{lc($rep_email)};

        ($mail_subj, $mail_body) = _compile_mail_from_template($tt_name, $rep_email_row->{lang}, $vars,
                                                               rep_fio => $rep_email_row->{FIO}, fio_var_name => $send_to_reps,
                                                               dyn_predefine => _make_dyn_predefine($rep_email_row),
            );

        if (defined $mail_body && defined $mail_subj) {
            my $recipients = { to => $rep_email };
            $recipients->{reply_to} =  $email->{reply_to} if ref($email) eq 'HASH' and defined $email->{reply_to} and $email->{reply_to};
            sendmail_with_logging($recipients, $from, $mail_subj, \$mail_body, 'text', $not_logging_flag, $tt_name, $vars->{client_id});
            $sent_emails{lc($rep_email)} = 1;
        }
    }

    return scalar keys %sent_emails;
}

#======================================================================

=head1 _compile_mail_from_template

    по имени шаблона, языку и хешу переменных возвращаем скомпилировнный текст и тему письма
    my ($mail_subj, $mail_body) = _compile_mail_from_template($tt_name, 'ru', $mail_vars, %OPT);

    необязательные параметры (%OPT):
    rep_fio - ФИО представителя
    fio_var_name - название переменной представляющей ФИО в $vars, если не задано то пытаемся достать это имя из шаблона письма

=cut

sub _compile_mail_from_template($$$;%) {
    my ($tt_name, $lang, $vars, %OPT) = @_;
    $vars = {%$vars, lang => $lang};

    $lang = _get_available_lang($tt_name, $lang);

    my $email_template = get_email_template($tt_name, $lang);
    die "$tt_name/$lang not found" if ! defined $email_template;

    my ($tt_content, $tt_subj) = ($email_template->{content}, $email_template->{subject});

    my ($mail_subj, $mail_body);

    # заменяем ФИО на ФИО представителя, если есть название переменной для ФИО (из параметров или из шаблона письма)
    if ($OPT{rep_fio} && ($email_template->{fio_var_name} || $OPT{fio_var_name})) {
        $vars->{ $email_template->{fio_var_name} || $OPT{fio_var_name} } = $OPT{rep_fio};
    }
    hash_merge $vars, $OPT{dyn_predefine};

    my $tt = _get_tt_object($lang);
    my $i18n_lang_guard = Yandex::I18n::init_i18n_guard($lang);
    my $tt_res = $tt->process(\$tt_content, $vars, \$mail_body);
    unless ($tt_res) {
        my $tt_error = $tt->error() . '';
        warn "$tt_error\n";
        send_alert(Dumper($tt_error, $tt_name, $tt_content, $vars) . '', "send_prepared_mail() error");
    }

    $tt_res = $tt->process(\$tt_subj, $vars, \$mail_subj);
    unless ($tt_res) {
        my $tt_error = $tt->error() . '';
        warn "$tt_error\n";
        send_alert(Dumper($tt_error, $tt_name, $tt_subj, $vars) . '', "send_prepared_mail() error (subj)");
    }

    # убираем повторяющиеся переводы строк без пробелов
    $mail_body =~ s/\n{3,}/\n\n/g;

    return ($mail_subj, $mail_body);
}


=head2 _make_dyn_predefine()

    сформировать умолчательные данные для шаблона письма
    один параметр -- ссылка на хэш:
      lang - код языка
      country_region_id - id страны
    результат -- ссылка на хэш с переменными

=cut
sub _make_dyn_predefine($) {
    my ($data) = @_;
    my $reg = $data->{country_region_id} // 0;
    my $lang = $data->{lang} // Yandex::I18n::default_lang();

    my $TLD_BY_REG = {
        $geo_regions::RUS => 'ru',
        $geo_regions::UKR => 'ua',
        $geo_regions::BY  => 'by',
        $geo_regions::KAZ => 'kz',
        $geo_regions::TR  => 'com.tr',
        other => 'com',
    };
    
    my $TLD_BY_LANG = {
        ru => 'ru',
        en => 'com',
        tr => 'com.tr',
        ua => 'ua',
    };
    
    my %ret = (
        lang => $lang,
        );
    
    
    if ($reg) {
        $ret{direct_tld} = $TLD_BY_REG->{$reg} // $TLD_BY_REG->{other};
    }
    else {
        $ret{direct_tld} = $MailNotification::host ? Yandex::URL::get_top_level_domain($MailNotification::host) : $TLD_BY_LANG->{$lang};
    }
    
    return \%ret;
}

#======================================================================

sub _mask_login {
    my $login = shift;
    if (length($login) < 5) {
        return "";
    }
    $login =~ s/^(.{2}).*(.)$/$1\*\*\*$2/;
    return $login;
}

=head1 send_prepared_sms

send sms from template

 $vars = {
     cid => $cid,   # !!! must exists unless dont_use_cid => 1 specified !!!
     uid => $uid,   # must exists if dont_use_cid => 1 specified
     sms_time => '09:00:21:00',  # clock interval for this SMS to be sent
     [...]
 };
 send_prepared_sms($tt_name, $vars, %O);

    my $uid = 10999940;
    send_prepared_sms('active_orders_money_warning_sms', $uid, {cid => 12345, procent => '33'});

=cut

sub send_prepared_sms
{
    my ($tt_name, $vars, %O) = @_;

    my $is_ya_agency_client = get_one_field_sql(PPC(uid => $vars->{uid}), [
        q/SELECT is_ya_agency_client FROM users u JOIN clients_options co ON (u.ClientID = co.ClientID)/,
        WHERE => {uid => SHARD_IDS}]
    );
    return 0 if $is_ya_agency_client;

    if (exists($vars->{client_login})) {
        $vars->{sms_client_login} = _mask_login($vars->{client_login});
    }

    my $lang;
    my $direct_tld;
    if ($O{dont_use_cid}) {
        # функции из User использовать нельзя из-за циклических зависимостей
        my $data = get_one_line_sql(PPC(uid => $vars->{uid}), ['
            SELECT u.lang, cl.country_region_id FROM users u LEFT JOIN clients cl on cl.ClientID = u.ClientID',
            WHERE => {uid => $vars->{uid}}
        ]);
        $direct_tld = _make_dyn_predefine($data)->{direct_tld};
        $lang = $data->{lang};
    } else {
        my $cid = $vars->{cid};
        return unless is_valid_int($cid);

        my $action_name = _tt_name_to_event_name($tt_name);
        unless($action_name){
            send_alert("Template for event '$tt_name' not found." . '', "send_prepared_sms() error");
            return;
        }

        my $data = get_one_line_sql(PPC(cid => $cid), ['
              SELECT u.lang, c.uid, FIND_IN_SET(?, co.sms_flags) AS need_sms, cl.country_region_id
                FROM campaigns c
                     LEFT JOIN users u ON c.uid = u.uid
                     LEFT JOIN clients cl on cl.ClientID = u.ClientID
                     LEFT JOIN camp_options co ON c.cid = co.cid
            ', WHERE => {'c.cid' => $cid}
        ], $action_name);
        # всегда отправляем CMC про ошибки автоплатежа и напоминание о необходимости внести деньги
        $data->{need_sms} = 1 if (any {$action_name eq $_} @SERVICE_SMS);
        return unless $data->{need_sms};
        $lang = $data->{lang};
        $direct_tld = _make_dyn_predefine($data)->{direct_tld};
        $vars->{uid} ||= $data->{uid};
    }
    $vars->{direct_tld} = $direct_tld || 'ru';
    $vars->{sms_pay_url} = _get_sms_pay_url_by_tld($vars->{direct_tld});

    $lang = 'ru' unless $lang;

    $lang = _get_available_lang($tt_name, $lang);

    return _send_prepared_sms($tt_name, $vars, $lang, %O);
}

sub _send_prepared_sms {
    my ($tt_name, $vars, $lang, %O) = @_;

    my $cid = 0;
    my $uid = $vars->{uid};
    $uid = 0 unless is_valid_int($uid, 0);

    if ( !$O{dont_use_cid} ) {
        $cid = $vars->{cid};
        return unless is_valid_int($cid, 0);
        if (!$uid) {
            $uid = get_owner(cid => $cid);
        }
    }

    my $template = get_email_template($tt_name, $lang);
    return if !defined($template);
    my $tt_data = $template->{subject};

    my $tt = _get_tt_object($lang);

    my $sms;
    {
        my $i18n_lang_guard = Yandex::I18n::init_i18n_guard($lang);
        $tt->process(\$tt_data, $vars, \$sms);
    }
    my $sms_time = $vars->{sms_time} || '';

    # получаем список представителей
    my @reps_uids = ($uid);
    if (!$template->{no_reps_sms}) {
        push @reps_uids, @{ get_one_column_sql(PPC(uid => $uid), "
                SELECT uid
                  FROM users
                       LEFT JOIN users_options USING(uid)
                 WHERE ClientID = (SELECT ClientID
                                     FROM users u2
                                    WHERE u2.ClientID > 0
                                          AND u2.uid = ?)
                       AND IFNULL(sendClientSMS, 'No') = 'Yes'
                       AND users.uid != ?
                ", $uid, $uid
            ) || []
        };
    }
    
    my @messages;
    push @messages, [$cid, $sms, $tt_name, $_, $sms_time] for @reps_uids;
    do_mass_insert_sql(PPC(uid => $uid),
        'INSERT INTO sms_queue (cid, sms_text, template_name, uid, sms_time) VALUES %s',
        \@messages
    );
    return scalar(@reps_uids);
}

sub _get_available_lang {
    my ($tt_name, $lang) = @_;

    my $fallback_lang = Yandex::I18n::get_base_locale($lang) || Yandex::I18n::default_lang();
    my $content = get_raw_email_template($tt_name, $lang);
    if (!$content || $content !~ /\S/) {
        $lang = $fallback_lang;
    }

    return $lang;
}

#======================================================================

=head1 process_sms_queue

  process sms queue (for exec from cron)
  my $sms_count = process_sms_queue(shard => NUM);

=cut

sub process_sms_queue
{
    my %O = @_;
    my $cids_param = $O{cid};
    
    my %queue_cid_condition = (defined($cids_param) && scalar(@$cids_param) > 0) ? ('s.cid' => $cids_param) : ();
    # PPC Умрет сразу, если указан неверный шард
    my $sms_queue = get_all_sql(PPC(shard => $O{shard}), [
        'SELECT sms_id
             , IF(s.uid, s.uid, c.uid) AS uid
             , s.cid, s.template_name
             , sms_text
             , o.sms_time, o.sms_flags
             , c.type
             , c.ClientID
          FROM sms_queue s
               LEFT JOIN campaigns c ON c.cid = s.cid
               LEFT JOIN camp_options o ON s.cid = o.cid',
         WHERE => {'s.send_status' => 'Wait', %queue_cid_condition}
    ]);

    my %uids_with_do_not_send_sms = _get_do_not_send_sms_uids(uniq map {$_->{uid}} @$sms_queue);

    my $sms_count = 0;
    
    for my $row (@$sms_queue) {

        my $action_name = _tt_name_to_event_name($row->{template_name});
        my $send_is_needed = 0;
        # если sms не по поводу какой-то кампании или она про ошибку автоплатежа или напоминание о платеже, то sms сервисная и её нужно отослать
        if( $row->{template_name} && (!$row->{cid} || any { $row->{template_name} eq $_ } @SERVICE_SMS) ) {
            $send_is_needed = 1;
        # если sms про какую-то кампанию и есть шаблон соответствующий событию
        # и так же есть включённая опция на кампании по поводу этого события, то отсылаем
        } elsif($row->{cid} && $action_name && $row->{sms_flags}) {
            $send_is_needed = any { $action_name eq $_ } split(',', $row->{sms_flags});
        }
        # отсылаем если это отправка остатка средств на 1/3 дня и включена фича принудительной отправки
        if($send_is_needed == 0 && $row->{template_name} && ($row->{template_name} eq 'active_orders_money_warning_sms')
            && is_new_wallet_warnings_client($row->{ClientID})		
            && is_send_sms_despite_sms_flags_for_new_wallet_warnings_client($row->{ClientID})
          ) 
        {
            $send_is_needed = 1;
        }
        
        next unless $send_is_needed;

        if (_is_curtime_matches_sms_time($row->{sms_time})) {
            my $uid = $row->{uid};
            my $send_status;
            if (exists $uids_with_do_not_send_sms{$uid}) {
                if ($O{log}) {
                    $O{log}->out("Skipping sending SMS (id: $row->{sms_id}) to user $uid: users_options.opts.do_not_send_sms is set");
                }
                $send_status = 'Send';
            } else {
                $send_status = ( send_single_sms( $uid, $row->{sms_text} )  ?  'Error' : 'Send' );
                $sms_count++;
            }
            do_sql(PPC(shard => $O{shard}),
                "UPDATE sms_queue SET send_status = ?, send_time = NOW() WHERE sms_id = ?",
                $send_status, $row->{sms_id}
            );
        }
    }

    return $sms_count;
}

sub _get_do_not_send_sms_uids {
    my (@uids) = @_;
    my $uids_with_do_not_send_sms = get_one_column_sql(PPC(uid => \@uids),
        ["SELECT uid FROM users_options",
        where => {
            opts__scheck => {do_not_send_sms => 1},
            uid => SHARD_IDS
        }]
    );
    return map {$_ => undef} @$uids_with_do_not_send_sms;
}

=head2 _is_curtime_matches_sms_time($sms_period)

   Надстройка над TimeCommon::is_time_yet. Возвращает 1, если текущее время попадает в sms_period

=cut


sub _is_curtime_matches_sms_time {
    my $sms_time = shift;

    my ($hour_from, $min_from, $hour_to, $min_to) = string2sms_time($sms_time);
    my $sms_period = {hour_from => $hour_from, min_from => $min_from, hour_to => $hour_to, min_to => $min_to};
    
    my (undef, $cur_min, $cur_hour) = localtime(time);

    if ($sms_period->{hour_from} == $sms_period->{hour_to} && $sms_period->{min_from} == $sms_period->{min_to}) {# круглосуточно
        $sms_period->{hour_from} = 0;
        $sms_period->{hour_to} = 24;
        $sms_period->{min_from} = $sms_period->{min_to} = 0;
    }

    return is_time_yet($cur_hour, $cur_min, $sms_period->{hour_from}, $sms_period->{min_from}, $sms_period->{hour_to}, $sms_period->{min_to});
}


=head2 expire_old_sms_in_queue

    Помечает ожидающие в очереди сообщения старше $SMS_EXPIRE_TIME как "Expired"
    Принимает именованные параметры:
        shard => NNN    - в каком шарде проверить/пометить смс как "просроченные"

=cut
sub expire_old_sms_in_queue{
    my %O = @_;

    do_sql(PPC(shard => $O{shard}), "
            UPDATE sms_queue
               SET send_status = 'Expire'
                   , send_time = NOW()
             WHERE send_status = 'Wait'
                   AND UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(add_time) > ?
        ", $SMS_EXPIRE_TIME
    );
}

sub _tt_name_to_event_name {
    my $tt_name = shift;
    my $TT_NAME_TO_EVENT_NAME = {
        'active_orders_money_out_sms'         => 'active_orders_money_out_sms',
        'active_orders_money_out_touch_sms'   => 'active_orders_money_out_sms',
        'active_orders_money_out_campaign_stopped_sms'         => 'active_orders_money_out_sms',

        'camp_finished_sms'                   => 'camp_finished_sms',
        'active_orders_money_warning_sms'     => 'active_orders_money_warning_sms',
        'active_orders_money_warning_touch_sms' => 'active_orders_money_warning_sms',
        'currency_convert_finished_sms'       => 'currency_convert_finished_sms',
        'moderate_result_sms'                 => 'moderate_result_sms',
        'moderate_result_touch_sms'           => 'moderate_result_sms',
        'notify_order_money_in_sms'           => 'notify_order_money_in_sms',
        'paused_by_day_budget_wallet_sms'     => 'paused_by_day_budget_sms',
        'active_orders_money_out_with_auto_overdraft_sms' => 'active_orders_money_out_sms',

        'autopay_error_not_enough_funds_sms'  => 'autopay_error_not_enough_funds_sms',
        'autopay_error_expired_card_sms'      => 'autopay_error_expired_card_sms',
        'autopay_error_other_sms'             => 'autopay_error_other_sms',

        'active_orders_money_out_reminder_sms'=> 'active_orders_money_out_reminder_sms',

        'cashback_consumed_notification_sms'  => 'notify_cashback_in_sms'
    };

    my $result = exists $TT_NAME_TO_EVENT_NAME->{$tt_name} ? $TT_NAME_TO_EVENT_NAME->{$tt_name} : 0;
    return $result;
}

#======================================================================


=head3 send_die_letters(text_error, extra_message)

    Отправляет письма о 500ых ошибках в веб-интерфейсе и АПИ.
    В зависимости от текста ошибки - может изменять заголовок писем, конкретизируя проблему.

    В переменных окружения не отображаются сертификаты из АПИ т.к. занимают много места и не имеют смысла при отладке.

=cut

sub send_die_letters
{
    my ($error, $extra_message) = @_;
    
    my $subj = "500 error";

    if (ref($error) eq 'HASH') {
        return 0 if $error->{dont_alert};
        $error = $error->{message};
    }

    if ($error =~ /advq.yandex.ru/) {
        $subj .= " - ADVQ";
    } elsif ($error =~ /ORDERS_NOT_SYNCHRONIZED/) {
        $subj .= " - Balance sync";
    } elsif ($error =~ /BANNED_AGENCY_TRANSFER/) {
        $subj .= " - Balance banned";
    } elsif ($error =~ /(API|Balance|DBStat|search|DBShards)\.pm/i) {
        $subj .= " - $1";
    }
    
    my $env_data = join("\n", map {$_ . " => " . $ENV{$_}} grep {!/^ssl.*?cert/i} sort keys %ENV);
    $env_data =~ s/(Session_id|sessionid2)=[^;\s]+/$1=SECRET/g;

    return send_alert(
        join("\n------------\n"
             , $error
             , $extra_message
             , $env_data
        )
        , $subj);

}


=head2 logging_for_sendmail

=cut

# Может, объединить logging_for_sendmail с log_mail?
sub logging_for_sendmail
{
    my %OPT = @_;

    local *F;
    if (open F, ">>:encoding(utf8)", $LOG.strftime("%Y%m%d", localtime())) {
        printf F "%s\t%s\t%s\n", strftime("%Y%m%d\t%T", localtime()), $OPT{to}, $OPT{subj};
        close F;
    } else {
        warn "Error logging sendmail: $!";
    }

    LogTools::log_mail($OPT{to}, $OPT{tt_name}, $OPT{subj}, $OPT{letter}, $OPT{client_id});

    return;
}



=head2 sendmail_with_logging

    отправка письма с логгированием
    
    Параметры -- как у Yandex::SendMail::sendmail

=cut 

sub sendmail_with_logging  
{

    local $Yandex::SendMail::logmail_sub = \&logging_for_sendmail;
    sendmail(@_);

    return;
}


{
my $tt_cache = {};
sub _get_tt_object
{
    my $lang = shift;

    if (! $tt_cache->{$lang}) {
        $tt_cache->{$lang} = Template->new({POST_CHOMP => 0
                                            , PRE_CHOMP => 0
                                            , PRE_DEFINE => {
                                                get_word_for_digit => \&get_word_for_digit,
                                                format_date => \&TTTools::format_date,

                                                # функции для работы с валютами. описание см. в Currencies и Currency::Texts
                                                format_sum_of_money => \&format_sum_of_money,
                                                format_const => \&format_const,
                                                convert_currency => \&convert_currency,
                                                get_currency_constant => \&get_currency_constant,
                                                get_currency_text => \&get_currency_text,
                                                conv_unit_explanation => sub { my ($pay_currency) = @_; return conv_unit_explanation('YND_FIXED', $pay_currency); },
                                                format_currency => \&format_currency,
                                                format_price => \&TTTools::format_price,
                                                get_help_url_absolute => \&Tools::get_help_url_absolute,
                                                get_geo_names => \&GeoTools::get_geo_names,
                                                human_device_type_targeting => \&TTTools::human_device_type_targeting,
                                                human_network_targeting => \&TTTools::human_network_targeting, 

                                                get_url => sub { my ($domain, $cmd, $params_hash) = @_; return TTTools::get_url("https://$domain/registered/main.pl", undef, $cmd, $params_hash); },
                                            }
                                            , LOAD_TEMPLATES => [Yandex::Template::Provider::Encoded->new(encoding => 'utf8'
                                                                                                        , INCLUDE_PATH => "$Yandex::MailTemplate::EMAIL_TEMPLATES_FOLDER/$lang/"
                                                                                                        , INTERPOLATE  => 0
                                                                                                         )]
                                            }) || die $Template::ERROR;
    }
    return $tt_cache->{$lang};
}
}


=head2 _is_serviced_by_special_manager($camp, $rbac)

    Проверяет менеджера агентской кампании и возвращает тип сервисирования
    Иначе возвращает undef

=cut
sub _is_serviced_by_special_manager {
    my ($camp, $rbac) = @_;

    # DIRECT-60362: если у агентства один из спец-менеджеров - считаем самоходом
    my $managers = rbac_get_all_managers_of_agency_clientid($rbac, $camp->{AgencyID});
    my $special_type = first {$_} map {User::get_special_manager_type($_)} @$managers;

    return $special_type;
}


=head2 _get_type_of_servicing

    Определяем тип сервисирования кампании. Требуется для понимая на какую рассылку и
    с какими заголовками отправлять письма.

    Позиционные параметры:
        camp

=cut
sub _get_type_of_servicing {

    my ($camp) = @_;
    

    if ($camp->{ManagerUID}) {
        my $user_info = get_user_info($camp->{uid});
        return 'manager_tr'  if $user_info->{country_region_id} == 983;
        return 'manager';
    }

    if (!$camp->{AgencyUID}) {
        my $user_info = get_user_info($camp->{uid});
        my $country_id = $user_info->{country_region_id};
        return 'self_tr'  if $country_id == 983;
        return 'self_ua'  if $country_id == 187;
        return 'self';
    }

    my $agency_info = get_user_info($camp->{AgencyUID});

    return 'agency_ua'  if $agency_info->{country_region_id} == 187;
    return 'agency';
}

=head2 send_document_to_otrs

    Отправить документы в OTRS
    На входе:
        files - указатель на массив файлов для отправки.
        cid - номер кампании
        именованные параметры:
            email - email, который ввел пользователь в форме.
            comment - комментарий, который ввел пользователь в форме.
            rbac
            manager_email - email менеджера, если кампания сервисируемая

=cut
sub send_document_to_otrs
{
    my ($files, $cid, %O) = @_;

    my @attaches;
    my @filenames;
    foreach my $file (@$files) {
        my $content = read_file($file);
        # не портим указатель на файл, имя файла кладем в отдельную переменную;
        my $filename = "".$file;
        $filename =~ s/[^\w\._\s]//g;
        push @filenames, $filename;
        my $type  = MIME::Types->new()->mimeTypeOf($filename) || 'application/octet-stream';
        push @attaches, {Type     => $type,
                         Filename => $filename,
                         Data     => $content,
                        };
    };


    my ($from, $to, $email);
    my $camp = CampaignQuery->get_campaign_data(cid => $cid, [qw/uid ManagerUID AgencyUID AgencyID/]);
    my $servicing_type = _get_type_of_servicing($camp);
    my $X_OTRS_header = $servicing_type;
    $email = join(",", @{$O{emails} || []});
    if ($servicing_type =~ /^self/) {
        $from = $O{emails}->[0];
    } elsif ($servicing_type =~ /^agency/) {
        my $special_type = _is_serviced_by_special_manager($camp, $O{rbac});
        if ($special_type) {
            $servicing_type = $special_type;
            $X_OTRS_header = $special_type =~ s/_agency//r;
            $from = $O{operator_email} // $O{emails}->[0];
            $email = $from;
        } else {
            $from = sprintf('Yandex.Direct <%s>', $Settings::DEFAULT_FROM_FIELD_DEPENDING_ON_LANG->{'ru'});
        }
    } else {
        if ($O{manager_email} && $servicing_type ne 'manager_tr') {
            $to = $O{manager_email};
        }
        $from = sprintf('Yandex.Direct <%s>', $Settings::DEFAULT_FROM_FIELD_DEPENDING_ON_LANG->{'ru'});
    }
    unless ($to) {
        $to = $OTRS_TICKET_EMAIL{$servicing_type};
    }

    $to = join(",", $to, $OTRS_ROBOT_EMAIL, 'robot-tcrm-test-sp@yandex-team.ru');
    my $subj = sprintf("Документы для прохождения модерации");
    my $text = <<END_MAIL;
Номер РК %d
E-mail: %s
Файлы:
%s
Комментарий:
%s
END_MAIL

    $text = sprintf($text, $cid, $email, "\t".join("\n\t", @filenames), $O{comment});

    my $email_headers = {};
    if ($O{operator_uid} && $O{client_id}) {
        my $hmac = Digest::HMAC_MD5->new($OTRS_SIGN_SALT);
        $hmac->add($O{operator_uid});
        $hmac->add($O{client_id});
        $hmac->add(Encode::encode_utf8($subj));

        $email_headers->{'X-Yandex-Direct-Operator-Uid'} = $O{operator_uid};
        $email_headers->{'X-Yandex-Direct-Client-Id'} = $O{client_id};
        $email_headers->{'X-Yandex-Direct-Sign'} = $hmac->hexdigest();
    }

    $email_headers->{'to'} = $to;
    $email_headers->{'X-OTRS-docs'} = $X_OTRS_header;

    sendmail_attach($email_headers, $from, $subj, $text, \@attaches, client_id => $O{client_id});
}

=head2 _get_short_pay_url_by_lang

    Получить сокращенную ссылку оплаты для отправки в SMS по домену верхнего уровня

=cut
sub _get_sms_pay_url_by_tld
{
    my $direct_tld = shift;

    my $pay_url = 'https://ya.cc/direct/pay';
    if ($direct_tld eq 'kz') {
        $pay_url = 'https://ya.cc/direct/kz_pay';
    } elsif ($direct_tld eq 'by') {
        $pay_url = 'https://ya.cc/direct/by_pay';
    } elsif ($direct_tld eq 'com') {
        $pay_url = 'https://ya.cc/direct/en_pay';
    } elsif ($direct_tld eq 'com.tr') {
        $pay_url = 'https://ya.cc/direct/tr_pay';
    }

    return $pay_url;
}

1;

