package Mcb;

=pod
    $Id$
    Работа с пакетами слов МКБ
=cut

use strict;
use warnings;

require Exporter;

use Settings;
use Yandex::DBTools;
use YaCatalogApi;
use Yandex::I18n;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
                 get_theme
                 get_theme_phrases
                 create_theme
);

use utf8;


# получить тему
sub get_theme {
    my $theme_id = shift or return undef;
    my $theme = get_one_line_sql(PPCDICT, "
            SELECT mt.theme_id, mt.parent_id, mt.name, mt.showsForecast, mt.categories, mt.lang
                 , (SELECT mt2.name FROM mcb_themes mt2 WHERE mt2.theme_id = mt.parent_id) as parent_name
              FROM mcb_themes mt
             WHERE mt.theme_id = ?
            ", $theme_id) or return undef;
    $theme->{phrases} = get_theme_phrases($theme_id);
    $theme->{categories_props} = [calc_categories_props([split /\s*,\s*/, $theme->{categories} || ''])];
    $theme->{categories_names} = [map { get_category_name($_) } (split /\s*,\s*/, ($theme->{categories} || ''))];
    return $theme;
}

# получить список фраз темы
sub get_theme_phrases {
    my $theme_id = shift;
    my $phrases = get_one_column_sql(PPCDICT, "SELECT phrase 
                                                 FROM mcb_theme_phrases 
                                                WHERE theme_id = ?", $theme_id) || [];
    return $phrases;
}

# вернуть всякие атрибуты категорий
sub calc_categories_props {
    my ($categories) = @_;
    return map { {
        category_id => $_,
        category_name => get_category_name($_),
        category_url => get_category_url($_),
        }
    } @$categories;
}

1;

