package MediaplanOptions;

=head1 NAME

    MediaplanOptions

=head1 DESCRIPTION

    Модуль с константами для формы заявки на медиаплан

=cut


use warnings;
use strict;

use utf8;

use Settings;
use Yandex::MyGoodWords;
use Yandex::I18n;
use PlacePrice qw//;

# типы заявки на медиаплан
our %REQUEST_TYPE = (
                            'text' => 'Подобрать текст',
                            'keywords_text' => 'Подобрать слова и текст',
                            'keywords' => 'Подобрать слова / расширение',
                            'optimize_wo_ext' => 'Оптимизировать без расширения',
                            'optimize_ext' => 'Оптимизировать с расширением',
);

our %REPORT_TYPE = (
    %REQUEST_TYPE,
    lego_mediaplan => iget_noop('LEGO-медиаплан'),
);



# типы оптимизации,  используются если типы заявки 'Оптимизировать без расширения' или 'Оптимизировать с расширением'
our %OPTIMIZE_TYPE = (
                            'your_opinion' => 'На ваше усмотрение',
                            'restore_disabled' => 'Восстановить отключенные',
                            'improve_text' => 'Улучшить тексты',
                            'add_minus_words' => 'Добавить минус-слова' ,
                            'specify_links' => 'Сделать более точные ссылки',
                            'clear_disabled' => 'Почистить отключенные',
                            'add_rubrics' => 'Добавлять рубрики Каталога',
                            'break_blocks' => 'Разбить блоки на более мелкие с точными текстами',
                            'add_sitelinks' => 'Добавить быстрые ссылки',
);

# типы баннеров для оптимизации,  используются если типы заявки 'Оптимизировать без расширения' или 'Оптимизировать с расширением'
our %OPTIMIZE_BANNER_TYPE = (
                            'active' => 'Активные',
                            'active_stop' => 'Активные+остановленные',
                            'all' => 'Все (включая остановленные и черновики)',
                            'by_id' => 'Объявления по номерам' ,
);


# уровни сложности заявки на медиаплан
our %DIFFICULTY_TYPE = (
                            'lite' => 'Лайт',
                            'standard'=> 'Стандарт',
                            'max' => 'Максимум',
);

# варианты изменений в тексте объявления:,  используются если тип заявки 'Подобрать текст'

our %SELECT_TEXT_TYPE = (
                            'brand_name' => 'Упоминать название компании/бренд',
                            'illumination' => 'Обязательно максимальная подсветка',
                            'template' => 'Использовать шаблон',
);

our %IMPROVEMENT = ( 'Text'        => {'request' => iget_noop('Хочу улучшить тексты объявлений'),
                                       'fa_list' => 'улучшить тексты',
                                       'order'   => 1},
                     'AddKeywords'     => {'request' => iget_noop('Хочу добавить ключевые слова'),
                                       'fa_list' => 'добавить ключевые слова',
                                       'order'   => 2},
                     'SpecifyKeyword'     => {'request' => iget_noop('Хочу уточнить ключевые слова'),
                                       'fa_list' => 'уточнить ключевые слова',
                                       'order'   => 3},
                     'AddAddress' => {'request' => iget_noop('Хочу добавить адрес и телефон'),
                                       'fa_list' => 'добавить адрес и телефон',
                                       'order'   => 4},
                     'AddSitelinks' => {'request' => iget_noop('Хочу добавить быстрые ссылки'),
                                       'fa_list' => 'добавить быстрые ссылки',
                                       'order'   => 5},
);

our @URL_TYPE = ('весь сайт', 'только выделенный раздел');

our @CLIENT_TEMPER = ('Жестко придерживаться пожеланий', 'Не менять тексты клиента', 'Можно менять тексты');

our @TARGET_AUDIENCE = ('В2В', 'В2С', 'Подробно');

our @POSITION = ('Спецразмещение', 'Первое место', 'Гарантия', 'Пожеланий нет');
our @POSITION_CTR_CORRECTION = ( (map { $PlacePrice::POSITION_CTR_CORRECTION_BY_PLACE{$_} } 
                                  ($PlacePrice::PLACES{PREMIUM1}, $PlacePrice::PLACES{PREMIUM2}, PlacePrice::get_premium_entry_place(), 
                                   $PlacePrice::PLACES{GUARANTEE1}, PlacePrice::get_guarantee_entry_place())
                                 ), 'Пожеланий нет');

our @DEPTH_TYPE = ('Небольшие общие правки', 'Стандарт', 'Глубокая');

our @TEXT_TYPE = ('Общий подход к заявке', 'Креатив');

our @GEO_TYPE = ('Как в объявлениях кампании', 'Уточнить');

our @QUERY_SELECTION = ('Узкие/точные тематические запросы', 
                        'Продающие запросы', 
                        'Контекстные запросы в рамках бюджета', 
                        'Максимум запросов по теме', 
                        'Широкий охват по теме и околотематические запросы',
                        'Запросы с ошибками, опечатками, транслитерацией',
                        'На ваше усмотрение',
                       );

our @PRIORITY = ('Обычно', 'Не срочно', 'ГОРИТ!!!');

our @END_BUTTON = ('Нажимать', 'Не нажимать');

our @NEED_CATALOG = ('Включать', 'Не включать');

our %ACCEPT_TYPE = (
    merge   => iget_noop("Стандартное принятие"),
    replace => iget_noop("Замена всей кампании"),
);

our %REJECT_REASON = (
    too_expensive => iget_noop('Дорого'),
    bad_texts => iget_noop('Тексты не подходят'),
    bad_keywords => iget_noop('Ключевые фразы не подходят'),
    weird_intraface => iget_noop('Непонятно, как принять улучшенные объявления'),
    have_questions => iget_noop('Есть вопросы по предложенным изменениям'),
    dont_need => iget_noop('Всё и так хорошо работает'),
    do_myself => iget_noop('Хочу самостоятельно улучшать кампанию'),
    other => iget_noop('Другое'),
);


=head2 hash_to_sorted_array($hash_ref)

    функция получает на вход ссылку на хэш и
    преобразовывает его в массив массивов.
    Используется для вывода содержимого хэша в поле select в форме
    Пример:
    {key1 => value1, key2 => value2}
    будет преобразован в 
    [[key1, value1], [key2, value2]]
  

=cut


sub hash_to_sorted_array{
    my $hash = shift;
    return [map { [$_, $hash->{$_}] } reverse sort {$hash->{$a} cmp $hash->{$b}} keys %$hash];
    
}

=head2 clear_and_split_string($string)

    функция получает на вход строку, вырезает из нее спецсимволы, разбивает на слова и выкидывает стоп-слова.
    Исключение составляют только символ минуса, потому что он охарактеризовывает минус слова.
    На выходе - ссылка на массив.

=cut
sub clear_and_split_string {
    my $string = shift;
    return [] if ! defined($string);

    $string = lc($string);
    $string =~ s/[^$ALLOW_LETTERS\s\-]//g;
    $string =~ s/['.]//g; #'
    my @words = split ' ', $string;
    @words = grep {! Yandex::MyGoodWords::is_stopword($_)} @words;
    return \@words;
}

1;
