package MobileApps;
use Direct::Modern;

=head1 NAME

MobileApps

=head1 DESCRIPTION

Работа с таблицей мобильных приложений в базе. Здесь только логика,
которую проще в perl сделать, чем дёргать через java-intapi.

=cut

use Yandex::DBTools;

use Settings;

=head2 is_mobile_app_present( $ClientID, $mobile_app_id )

Есть ли приложение с таким ID у клиента с таким ID

=cut

sub is_mobile_app_present {
    my ( $ClientID, $mobile_app_id ) = @_;
    
    my $fetched_mobile_app_id = get_one_field_sql( PPC( ClientID => $ClientID ), [
        'SELECT mobile_app_id FROM mobile_apps',
        WHERE => { ClientID => $ClientID, mobile_app_id => $mobile_app_id }
    ] );
    
    return $fetched_mobile_app_id ? 1 : 0;
}

=head2 get_store_href( $ClientID, $mobile_app_id )

Возвращает store_href для приложения с таким ID у клиента с таким ID

=cut

sub get_store_href {
    my ( $ClientID, $mobile_app_id ) = @_;
    
    my $client_store_href = get_one_field_sql( PPC( ClientID => $ClientID ), [
        'SELECT store_href FROM mobile_apps',
        WHERE => { ClientID => $ClientID, mobile_app_id => $mobile_app_id }
    ] );
    
    return $client_store_href;
}

=head2 get_mobile_app_id_by_store_href( $ClientID, $store_href )

Возвращает mobile_app_id для приложения с таким store_href у клиента с таким ID

=cut

sub get_mobile_app_id_by_store_href {
    my ( $ClientID, $store_href ) = @_;
    
    my $client_mobile_app_id = get_one_field_sql( PPC( ClientID => $ClientID ), [
        'SELECT max(mobile_app_id) FROM mobile_apps',
        WHERE => { ClientID => $ClientID, store_href => $store_href }
    ] );
    
    return $client_mobile_app_id;
}

=head2 get_mobile_app_id_by_mobile_content_id( $ClientID, $mobile_content_id )

Возвращает mobile_app_id самого нового приложения с таким mobile_content_id

=cut

sub get_mobile_app_id_by_mobile_content_id {
    my ( $ClientID, $mobile_content_id ) = @_;

    my $mobile_app_id = get_one_field_sql( PPC( ClientID => $ClientID ), [
        'SELECT max(mobile_app_id) FROM mobile_apps',
        WHERE => { ClientID => $ClientID, mobile_content_id => $mobile_content_id }
    ] );

    return $mobile_app_id;
}

=head2 get_mobile_app_ids_by_mobile_content_ids( $ClientID, $mobile_content_ids )

    Возвращает хэш {mobile_content_id => mobile_app_id} в котором mobile_app_id -- идентификатор
    самого нового приложения соотвествующего mobile_content_id

=cut

sub get_mobile_app_ids_by_mobile_content_ids {
    my ( $ClientID, $mobile_content_ids ) = @_;

    my $mobile_app_ids = get_hash_sql( PPC( ClientID => $ClientID ), [
        'SELECT mobile_content_id, max(mobile_app_id) FROM mobile_apps',
        WHERE => { ClientID => $ClientID, mobile_content_id => $mobile_content_ids }
    ] );

    return $mobile_app_ids;
}

1;
