use strict;
use warnings;
use utf8;

package Models::DesktopBanner;

use base qw/Exporter/;
our @EXPORT = qw//;
our @EXPORT_OK = qw/
    create_desktop_banner
    
    create_desktop_banners
    update_desktop_banners
/;

use Models::Banner qw//;
use Yandex::HashUtils;

=head2 create_desktop_banner($banner, $uid)

    Создание одного десктопного баннера (вместе с визиткой, сайтлинками и картинкой) для одного пользователя.
    
    Параметры:
        см. create_desktop_banners
        
    Результат:
        $banner - исходный баннер с выставленным значением bid
    
=cut

sub create_desktop_banner {
    
    my ($banner, $uid) = @_;
    
    return create_desktop_banners([$banner], $uid)->[0];
}

=head2 create_desktop_banners($banners, $uid)

    Создание десктопных баннеров (вместе с визиткой, сайтлинками и картинкой) для одного пользователя.
    Полное описание, входные параметры и результат см. в Models::Banner::create_base_banners

    Опции:
        ignore_callouts => 1|0 - не менять уточнения на баннере

=cut

sub create_desktop_banners {
    my ($banners, $uid, $options) = @_;

    $options ||= {};
    my $base_options = hash_cut $options, qw/ignore_callouts/;
    
    $_->{banner_type} = 'desktop' foreach @$banners;
    return Models::Banner::create_base_banners($banners, $uid, $base_options);
}

=head2 update_desktop_banners($banners, $uid, $options)

    Сохранение изменений в десктопных баннерах (вместе с визиткой, сайтлинками и картинкой) для одного пользователя.
    Полное описание, входные параметры и результат см. в Models::Banner::update_base_banners
                
=cut

sub update_desktop_banners {
    
    my ($banners, $uid, $options) = @_;
    $options ||= {};
    
    $_->{banner_type} = 'desktop' foreach @$banners;
    my $base_options = hash_cut $options, qw/ignore_vcard geo_camp_vcard moderate_declined ignore_sitelinks ignore_image ignore_callouts/;
    return Models::Banner::update_base_banners($banners, $uid, $base_options);
}



1;
