use strict;
use warnings;
use utf8;

package Models::MobileBanner;

use base qw/Exporter/;
our @EXPORT = qw//;
our @EXPORT_OK = qw/
    create_mobile_banner
    update_mobile_banner

    create_mobile_banners
    update_mobile_banners
/;

use Models::Banner;
use Yandex::HashUtils;


=head2 create_mobile_banner($banner, $uid)

    Создание одного мобильного баннера для одного пользователя.
    
    Параметры:
        см. create_mobile_banners
        
    Результат:
        $banner - исходный баннер с выставленным значением bid
    
=cut

sub create_mobile_banner {
    
    my ($banner, $uid) = @_;
    
    return create_mobile_banners([$banner], $uid)->[0];
}

=head2 create_mobile_banners($banners, $uid)

    Создание мобильных баннеров (вместе с визиткой, сайтлинками и картинкой) для одного пользователя.
    Полное описание, входные параметры и результат см. в Models::Banner::create_base_banners

=cut

sub create_mobile_banners {
    
    my ($banners, $uid) = @_;
    
    $_->{banner_type} = 'mobile' foreach @$banners;
    return Models::Banner::create_base_banners($banners, $uid);
}


=head2 update_mobile_banner($banner, $uid)

    Сохранение изменений в одном мобильном баннере для одного пользователя.
    
    Параметры:
        см. update_mobile_banners
        
    Результат:
        $banner - исходный баннер

=cut

sub update_mobile_banner {
    
    my ($banner, $uid) = @_;
    
    return update_mobile_banners([$banner], $uid)->[0];
}

=head2 update_mobile_banners($banners, $uid, $options)

    Сохранение изменений в мобильных баннерах (вместе с визиткой, сайтлинками и картинкой) для одного пользователя.
    
    Параметры:
        $banners - массив [] баннеров, описание см. в Models::Banner::update_base_banners
        $uid - uid владельца
        $options - хеш {} с параметрами функции (может отсутствовать)
            moderate_declined => 1|0 - 1 повторная отправка на модерацию отклоненного баннера и/или визитки, даже если они не изменились
            
    Результат:
        $banners - исходный массив [] баннеров            

=cut

sub update_mobile_banners {
    
    my ($banners, $uid, $options) = @_;
    $options ||= {};
    
    $_->{banner_type} = 'mobile' foreach @$banners;
    my $base_options = hash_cut $options, qw/ignore_vcard moderate_declined ignore_sitelinks ignore_image/;
    return Models::Banner::update_base_banners($banners, $uid, $base_options);
}

1;
