use strict;
use warnings;
use utf8;

package Models::PhraseTools;

use base qw/Exporter/;
our @EXPORT = qw/
    phrase_should_null_phrase_id
/;

use Yandex::MyGoodWords;

=head2 phrase_should_null_phrase_id

    Проверяем надо ли обнулять CTR фразы и удалять PhraseID

=cut

sub phrase_should_null_phrase_id($){
    my ($ph) = @_; 

    my ($phrase, $old_ph) = map {$ph->{$_}} qw/phrase phrase_old/;
    
    my $norm_phrase = lc(Yandex::MyGoodWords::norm_words($phrase, 1));
    my $norm_phrase_old = lc(Yandex::MyGoodWords::norm_words($old_ph, 1) // "");
    my ($added, $deleted, $addedno, $deletedno) = find_changes($norm_phrase, $norm_phrase_old);
    my $erase = $deleted > 0 ? 1 : 0;

    return $erase;
}

=head2 find_changes

    Находит и возвращает разлиция в двух фразах

=cut
sub find_changes
{
    my ($norm_phrase, $norm_phrase_old) = @_;

    # не обращать внимания на кавычки
    $norm_phrase =~ s/[\"\!\+]//g;
    $norm_phrase_old =~ s/[\"\!\+]//g;

    my @words = split(/ /, $norm_phrase);
    my (%WordsNew, %NoWordsNew);
    for (my $i=0;$i<=$#words;$i++) {
        $words[$i] =~ s/^\s*//g;
        $words[$i] =~ s/\s*$//g;
        if ($words[$i] =~ m/^-.*/) {
            $words[$i] =~ s/.(.*)/$1/;
            $NoWordsNew{$1} = 1;
        } else {
            $WordsNew{$words[$i]} = 1;
        }
    }
    @words = split(/ /, $norm_phrase_old);
    my (%WordsOld, %NoWordsOld);
    for (my $i=0;$i<=$#words;$i++) {
        $words[$i] =~ s/^\s*//g;
        $words[$i] =~ s/\s*$//g;
        if ($words[$i] =~ m/^-.*/) {
            $words[$i] =~ s/.(.*)/$1/;
            $NoWordsOld{$words[$i]} = $1;
        } else {
            $WordsOld{$words[$i]} = $words[$i];
        }
    }
    my ($added, $deleted, $addedno, $deletedno) = (0, 0, 0, 0);
    foreach (keys %WordsNew) {
        $added++ unless defined ($WordsOld{$_});
    }
    foreach (keys %WordsOld) {
        $deleted++ unless defined ($WordsNew{$_});
    }
    foreach (keys %NoWordsNew) {
        $addedno++ unless defined ($NoWordsOld{$_});
    }
    foreach (keys %NoWordsOld) {
        $deletedno++ unless defined ($NoWordsNew{$_});
    }
    return ($added, $deleted, $addedno, $deletedno);
}

1;
