package Moderate::ExportMaster;

=encoding utf8

=head1 NAME
    
    Moderate::ExportMaster

=head1 DESCRIPTION

    Функции для работы moderateExportMaster.pl

=cut

use strict;
use warnings;

use feature qw/state/;

use Settings;
use Moderate::ResyncQueue;
use HashingTools ();

use Yandex::DBTools;
use Yandex::DateTime;

use List::Util qw/sum max min/;
use List::MoreUtils qw/uniq/;

use utf8;

=head2 @STATS_PAR_TYPES

    типы очередей для мониторинга

=cut
our @STATS_PAR_TYPES = qw/all std/;

=head2 @STATS_PERCENTILES

    перцентили для мониторинга

=cut
our @STATS_PERCENTILES = qw/80 90 95 99 100/;

=head2 @STATS_NUMS

    типы статистик для мониторинга

=cut
# TODO: унифицировать перечисление счетчиков объектов + подтягивать счетчики объектов, наследуемых от Moderate::Objects::Base (типа image_ads_num)
our @STATS_NUMS = qw/max_age
                     total_size
                     users_num
                     camps_num banners_num adgroups_num contactinfos_num sitelinks_sets_num
                     images_num display_hrefs_num image_ads_num cmds_num turbolandings_num
                   /;

=head2 init(%options)

    Первоначальная установка переменных
    %options:
        shard - номер шарда
        log - объект Yandex::Log
=cut

my ($SHARD, $log);
sub init {
    my %options = @_;
    ($SHARD, $log) = @options{qw/shard log/};
    die "shard is not defined" unless $SHARD;
    die "Yandex::Log object is not defined" unless $log;
}

=head2 process_resync_queue

    Обработка очереди ленивой переотправки

=cut

sub process_resync_queue {
    my (%O) = @_;

    my $iter_uuid = $O{iter_uuid} || HashingTools::generate_uuid();
    my $msg_prefix = $log->msg_prefix() || '';    
    
    $log->msg_prefix(join "\t", grep { $_ } $msg_prefix, "[$iter_uuid]") unless $O{iter_uuid};

    # обрабатываем ленивую очередь переотправки mod_resync_queue
    # TODO: считать статистику в java и писать результат в проперти, здесь читать из них, код calc_queue_stats — удалить
    my $stat_cb = sub { calc_queue_stats( get_queue_stats() ) };
    if (!$O{skip_resync}) {
        $log->out('processing resync queue');
        Moderate::ResyncQueue::process_resync_queue($stat_cb, $SHARD);
    }
}

=head2 get_queue_stats($shard)

    Получить объекты в очереди у заданного шарда, по типам очередей
    $shard || $SHARD  $SHARD == init(shard => ?)

    Результат:
    {
        partype => [{....}],
        all => [{....}],
        shard_id => ...
    }
    
=cut

sub get_queue_stats {
    
    my $shard = shift || $SHARD;
    # считаем статистики, пишем данные для мониторингов
    # TODO: унифицировать перечисление счетчиков объектов + подтягивать счетчики объектов, наследуемых от Moderate::Objects::Base (типа image_ads_num)
    my $queue = get_all_sql(PPC(shard => $shard), "
                        SELECT q.cid,
                               'std' AS par_type,
                               c.uid,
                               timestampdiff(SECOND, queue_time, now()) AS age,
                               camps_num + adgroups_num + banners_num + contactinfos_num + sitelinks_sets_num + images_num + display_hrefs_num + image_ads_num + turbolandings_num AS total_size,
                               camps_num, adgroups_num, banners_num, contactinfos_num, sitelinks_sets_num, images_num, display_hrefs_num, image_ads_num, cmds_num, turbolandings_num
                          FROM mod_export_queue q
                          JOIN campaigns c USING(cid)
                     LEFT JOIN users u ON u.uid = c.uid
                         WHERE camps_num + adgroups_num + banners_num + contactinfos_num + sitelinks_sets_num + images_num + display_hrefs_num + image_ads_num + cmds_num  + turbolandings_num > 0
                               AND (u.uid IS NULL OR u.statusBlocked <> 'Yes') ");
    my %by_par_type;
    for my $item (@$queue) {
        push @{$by_par_type{$item->{par_type}}}, $item;
        push @{$by_par_type{all}}, $item;
    }
    $by_par_type{shard} = $shard; 
    
    return \%by_par_type;
}

=head2 calc_queue_stats

    посчитать статистику по объектам в очереди для каждого @STATS_PAR_TYPES и @STATS_NUMS

=cut

sub calc_queue_stats {
    
    my $by_par_type = shift;
    
    my $stats = {};        
    # аггрегируем по par_type и перцентилям
    for my $par_type (@STATS_PAR_TYPES) {
        my @data = sort {
                            $a->{age} <=> $b->{age}
                            or $a->{uid} <=> $b->{uid}
                            or $a->{cid} <=> $b->{cid}
                        } @{$by_par_type->{$par_type} || []};
        for my $percentile (@STATS_PERCENTILES) {
            my @chunk = @data ? @data[0 .. int($#data * $percentile / 100 + 0.5)] : ();
            # для 100% - перцентиль не выводим в название
            my $pstat = $stats->{$percentile eq '100' ? $par_type : "${par_type}_${percentile}"} = {};
            for my $field (@STATS_NUMS) {
                if ($field eq 'max_age') {
                    $pstat->{max_age} = @chunk ? $chunk[-1]->{age} : 0;
                    $pstat->{max_age_minutes} = int($pstat->{max_age} / 60);
                } elsif ($field eq 'users_num') {
                    $pstat->{$field} = scalar(uniq map { $_->{uid} } @chunk) || 0;
                } else {
                    $pstat->{$field} = sum(map {$_->{$field} || 0} @chunk) || 0;
                }
            }
        }
    }
    
    return $stats;
}
1;
