package Moderate::JSONRPC::Client;

use strict;
use warnings;

use Net::INET6Glue::INET_is_INET6;
use JSON::RPC::Simple::Client;

sub new
{
    my ($class, @options) =  @_;

     my $obj = new JSON::RPC::Simple::Client(@options);
 #   my $obj = new JSON::RPC::Simple::Client($options[0], {json => MyJSON->new()});

    return bless { rpc_simple_client => $obj }, $class;
}

our $AUTOLOAD;
sub AUTOLOAD 
{
    my ($self, @params) = @_;
    my $method = $AUTOLOAD;
    $method =~ s/.*:://;   
    my $response;

    eval {
           $response = $self->{rpc_simple_client}->$method(\@params);
    };

    if ($@) {
        warn "FAILED $@!";
        $self->{failed} = $@;
        return undef;
    }
    else {
        $self->{failed} = undef;
        return $response;
    }
}

sub DESTROY {
    # destroy не нужно пытаться превратить в RPC.
}

sub faultstring
{
    my ($self) = @_;
    return $self->{failed};
}

package MyJSON;
use strict;
use warnings;
use JSON;

sub new
{
    my ($class) = @_;
    return bless {}, $class;
}

sub decode
{
    my ($self, $data) = @_;
    my $js = JSON->new()->utf8();
    return  $js->decode($data);
}

sub encode
{
    my ($self, $data) = @_;
    my $js = JSON->new()->utf8();
    my $json_text = $js->encode($data);
    open my $fd, '>>','./jsonrpc.log' or die $!;

    print $fd "$json_text\n\n";
    return $json_text;
}


1;
