package Moderate::Quick;

=head1 NAME

    Moderate::Quick - общение с "быстрой" модерацией

=head1 DESCRIPTION

    Сюда переехали из Common.pm функции относящиеся к быстрой модерации
    Некрасиво - зато отдельно

=cut

use strict;
use warnings;

use Yandex::DBTools;
use Yandex::Validate;
use Yandex::ScalarUtils;

use Settings;
use Moderate::Settings;
use geo_regions;
use LogTools;
use Campaign::Types qw/camp_kind_in/;

use base qw/Exporter/;

our @EXPORT = qw/
    quick_moderate
    check_quick_moderate
    preliminary_moderate_campaign
/;


sub quick_moderate
{
    my $camp    = shift;
    my $client  = shift;

    unless ( check_quick_moderate($camp, $client) ) {
    	return ({result => -1});
    }

    # Ручка быстрой модерации давно уже не работала. Чтобы не слишком сильно менять продуктовую логику,
    # просто заменим её вызов на возврат пустого значения.
    return undef;
}

=head1 check_quick_moderate($camp, $client)

    Получить результат быстрой модерации

    Параметры:

    $camp   - данные кампании
    $client - данные клиента. В данный момент интересует страна клиента, country_region_id

    Результат: 1, если прошла, иначе 0

=cut

sub check_quick_moderate
{
	my ($camp, $client) = (shift, shift);

	if ($camp->{ManagerUID} 
            || $camp->{AgencyUID} 
            || $camp->{OfferServicing} 
            || $camp->{UserNotResident} && $camp->{UserNotResident} eq 'Yes'
            || ($client && $client->{country_region_id} != $geo_regions::RUS)
            || ($camp->{currency} ne 'YND_FIXED' && $camp->{currency} ne 'RUB')
            # Перфоманс кампании и кампании внутренней рекламы не могут быть отмодерированными через механизм quick moderate
            # Они должны быть отправлены в модерацию, чтобы модерация сохранила у себя этот объект кампании:
            # он необходим, чтобы привязывать к нему документы, которые будет предоставлять клиент
            || camp_kind_in(type => $camp->{type}, 'mod_export_campaigns_only')
	) {
		return 0;
	}
	
	return 1;
}

=head3 preliminary_moderate_campaign(dbh, cid, modresult)

    Устанаваливаем флаг предварительной модерации для кампании
        = разрешаем оплату до результатов модерации

=cut

sub preliminary_moderate_campaign
{   
    my ($cid, $modresult) = @_;
    
    die unless is_valid_id($cid);

    my $where = {'c.cid' => $cid};
    my $set = {};
    # обрабатываем ответ с модерации
    if ($modresult && $modresult->{result} > 0) {
        $where->{'c.statusModerate__not_in'} = [qw/Yes No/];
        $set = {
            'statusModerate' => 'Yes',
            'statusPostModerate__dont_quote' => "IF(statusPostModerate = 'Accepted', 'Accepted', 'Yes')"
        }; 
    } elsif (!$modresult || $modresult->{result} <= 0) {
        $set = {'statusPostModerate' => 'No'};
        $where->{'co.statusPostModerate__ne'} = 'Accepted';
    }
    
    eval {
        # logging result of quick moderate    
        LogTools::log_messages('quick-moderate', "$cid\t$modresult->{result}");
    };
    
    do_update_table(PPC(cid => $cid), 'campaigns c join camp_options co using(cid)', $set, where => $where) if %$set;
}

1;
