package Moderate::ReModeration;

=encoding utf8

=head1 NAME

    Moderate::ReModeration - управляет специальными флагами на объявлениях - auto_accept и only_manual

=cut

use Direct::Modern;
use Yandex::DBTools;

use Settings;

my %link_fields = map {$_ => 1} qw/banner sitelinks_set contactinfo banner_image image turbolanding display_hrefs/;

=head2 set_pre_moderation_flag

    Устанавливает флаг о необходимости ручной модерации объявления. Находит связанные подобъекты и проставляет флаги на них.

=cut

sub set_pre_moderation_flag 
{
    my ($class, $bids_to_moderate) = @_;
    return $class->_insert_into_flag_table("pre_moderate_banners", $bids_to_moderate);
}

=head2 set_auto_moderation_flag

    Устанавливает флаг о необходимости принудительного одобрения объявления на модерации. Находит связанные подобъекты и проставляет флаги на них.

=cut

sub set_auto_moderation_flag 
{
    my ($class, $bids_to_moderate) = @_;
    return $class->_insert_into_flag_table("auto_moderate", $bids_to_moderate);
}

sub _check_table_name
{
    my ($class, $table_name) = @_;

    if ($table_name !~ /^(pre_moderate_banners|auto_moderate)$/) {
        die "Unknown table $table_name";
    }
}

sub _insert_into_flag_table 
{
    my ($class, $table_name, $bids_to_moderate) = @_;

    $class->_check_table_name($table_name);

    my $ppc_shard = PPC(bid => $bids_to_moderate);

    do_sql($ppc_shard,[ 
                "insert into $table_name
                    (bid, send_banner, send_sitelinks_set, send_contactinfo, send_banner_image, send_image, send_turbolanding, send_display_hrefs, send_banner_logo, send_banner_button, send_multicard)
                select bid,
                        1,
                        NOT(ISNULL(sitelinks_set_id)),
                        NOT(ISNULL(vcard_id)),
                        NOT(ISNULL(bi.bid)),
                        NOT(ISNULL(i.bid)),
                        NOT(ISNULL(bt.bid)),
                        NOT(ISNULL(bdh.bid)),
                        NOT(ISNULL(bl.bid)),
                        NOT(ISNULL(bb.bid)),
                        NOT(ISNULL(bms.bid))
                 from banners 
                      left join banner_images bi using(bid) 
                      left join images i using(bid) 
                      left join banner_turbolandings bt using(bid) 
                      left join banner_logos bl using(bid)
                      left join banner_buttons bb using(bid)
                      left join banner_multicard_sets bms using(bid)
                      left join banner_display_hrefs bdh using(bid)",
                 where => {bid => $bids_to_moderate},
                "on duplicate key update
                        send_banner = values(send_banner),
                        send_sitelinks_set = values(send_sitelinks_set),
                        send_contactinfo  = values(send_contactinfo),
                        send_banner_image = values(send_banner_image),
                        send_image = values(send_image),
                        send_turbolanding = values(send_turbolanding),
                        send_banner_logo = values(send_banner_logo),
                        send_banner_button = values(send_banner_button),
                        send_multicard = values(send_multicard),
                        send_display_hrefs = values(send_display_hrefs)"
                    ]
             );

}

=head2 try_to_remove_auto_moderate_flag
 
    Удаляет флаги, если не осталось пометок о подобъектах

=cut

sub try_to_remove_auto_moderate_flag
{
    my ($class, $bids_to_moderate) = @_;
    return $class->_try_to_remove("auto_moderate", $bids_to_moderate);
}

sub _try_to_remove 
{
    my ($class, $table_name, $bids_to_moderate) = @_;

    $class->_check_table_name($table_name);

    my $ppc_shard = PPC(bid => $bids_to_moderate);

    do_delete_from_table($ppc_shard, $table_name, where => { bid => $bids_to_moderate, map { "send_".$_ => 0 } keys %link_fields});
}


1;
