package Moderate::Settings;
## no critic (TestingAndDebugging::RequireUseStrict, TestingAndDebugging::RequireUseWarnings)

=pod

    Настройки для экспорта объявлений из Директа в Модерацию

=cut
use Net::INET6Glue::INET_is_INET6;

our $MODERATE_JSON_URL ||= 'http://intapi.direct-mod.yandex.ru:7080/jsonrpc/';
our $MODERATE_JSON_PROXY_URL ||= 'http://modadvert.yandex-team.ru/direct_proxy/';
our $MODERATE_URL ||= 'http://intapi.direct-mod.yandex.ru:7080/soap/';

our $MODERATE_JSON_RPC_URL_PROPERTY ||= 'use_moderate_jsonrpc_proxy_url';
our $PROPERTY_CACHE_TIME = 300;

# максимальный размер пачки для очереди команд
our $PROCESS_MAGIC_QUEUE_CHUNK_SIZE ||= 500;

# максимально возможное (штатно, по крону) кол-во потоков в одном шарде
our $MAX_PAR_ID = 5;

# кол-во объектов в одной итерации экспорта
our $MODERATE_TEXT_LIMITS_CAMPS ||= 500;
our $MODERATE_TEXT_LIMITS_BANNERS ||= 500,
# это значение можно переопределить через Property
our $MODERATE_TEXT_LIMITS_ADGROUPS ||= 500;
our $MODERATE_TEXT_LIMITS_CONTACTINFOS ||= 500;
our $MODERATE_TEXT_LIMITS_SITELINKS_SETS ||= 500;
our $MODERATE_TEXT_LIMITS_IMAGES ||= 500;
our $MODERATE_TEXT_LIMITS_DISPLAY_HREFS ||= 500;
our $MODERATE_TEXT_LIMITS_CMDS ||= 20;
our $MODERATE_TEXT_LIMITS_IMAGE_ADS ||= 500;
our $MODERATE_TEXT_LIMITS_VIDEO_ADDITIONS ||= 500;
our $MODERATE_TEXT_LIMITS_TURBOLANDINGS ||= 500;
our $MODERATE_TEXT_LIMITS = {
    camps => $MODERATE_TEXT_LIMITS_CAMPS,
    banners => $MODERATE_TEXT_LIMITS_BANNERS,
    adgroups => $MODERATE_TEXT_LIMITS_ADGROUPS,
    contactinfos => $MODERATE_TEXT_LIMITS_CONTACTINFOS,
    sitelinks_sets => $MODERATE_TEXT_LIMITS_SITELINKS_SETS,
    images => $MODERATE_TEXT_LIMITS_IMAGES,
    display_hrefs => $MODERATE_TEXT_LIMITS_DISPLAY_HREFS,
    cmds => $MODERATE_TEXT_LIMITS_CMDS,
    image_ads => $MODERATE_TEXT_LIMITS_IMAGE_ADS,
    video_additions => $MODERATE_TEXT_LIMITS_VIDEO_ADDITIONS,
    turbolandings => $MODERATE_TEXT_LIMITS_TURBOLANDINGS,
    video_additions_cpm_video => $MODERATE_TEXT_LIMITS_VIDEO_ADDITIONS,
};
# количество кампаний которые лочим для дальнейшей обработки воркером
our $MODERATE_CAMP_LOCK_LIMIT ||= 500;

# Имя mysql-лока для moderateClientNew и мастера
our $MODERATE_CLIENT_LOCK_NAME ||= 'MODERATE_CLIENT';
our $MODERATE_WORKER_LOCK_NAME ||= 'MODERATE_WORKER';
our $MODERATE_MASTER_LOCK_NAME ||= 'MODERATE_EXPORT_MASTER';

# количество минут, которое чрезмерно активный пользователь будет пессимизироваться в экспорте
our $MODERATE_TIME_PESSIM_LIMIT ||= 2;

# определяет "чрезмерно активного пользователя", количество баннеров за одну итерацию экспорта, после которой
# пользователь 10 минут будет пессимизироваться
our $MODERATE_BAN_CNT_PESSIM_LIMIT ||= 900;

# таймаут для запроса быстрой модерации
our $QUICK_MODERATE_TIMEOUT ||= 4;

# список тестовых ClientID, чьи объекты не будут обрабатываться moderateExportMaster.pl и moderateClientNew.pl
# без указания конкретных id объектов (--cid=, --mobile-content-id=, --additions-item-id=)
# переопределяется в perl/SettingsTest.pm
our $IGNORE_TEST_CLIENTS_IN_TRANSPORT //= [];

1;
