package Moderate::Tools;
## no critic (TestingAndDebugging::RequireUseWarnings)

use strict;
use feature q/state/;
use Settings;
use Moderate::Settings;

use EnvTools;

=head2 get_moderation_jsonrpc_url

    Получить url по которому ходить в модерацию

    В зависимости от значения флага в ppc_properties используем url новой прокси модерации(1) или старый url модерации(0)

    Возвращает строку с url

    прараметры:
    {
     use_cache => 1|0 - флаг испльзовать/неиспльзовать кэш
    }
=cut

sub get_moderation_jsonrpc_url
{
    my ($opts) = @_;
    if (EnvTools::is_beta()) {
        return $Moderate::Settings::MODERATE_JSON_URL;
    }

    state $property //= Property->new($Moderate::Settings::MODERATE_JSON_RPC_URL_PROPERTY);
    my $cache_time = ($opts->{use_cache})? $Moderate::Settings::PROPERTY_CACHE_TIME : 0;

    return $property->get($cache_time) ? $Moderate::Settings::MODERATE_JSON_PROXY_URL : $Moderate::Settings::MODERATE_JSON_URL;
}

1;
__END__
