package OkrTextExport;


use warnings;
use strict;

use JSON qw/to_json/;
use LogTools qw/log_messages/;
use HashingTools qw//;

use base qw/Exporter/;
our @EXPORT_OK = qw/
  log_pz_report_params_for_okr 
/;


=pod
=head1 NAME

    OkrTextExport - экспорт добавляемых пользователем ключевых/минус слов в Отдел Качества Рекламы (ОКР) из отчета Поисковые Запросы (ПЗ).        

=head1 DESCRIPTION

   Экспорт нужен для организации обратной связи для настройки алгоритмов broadmatch ОКР.

=head1 METHODS



=cut


=head3 log_pz_report_params_for_okr($perator_uid, $cid2orderid_mapping, $bem_vars, $matchedKeywordsIds)

    Логирует параметры отчета в messages.log.

=cut

sub log_pz_report_params_for_okr {
    my ($operator_uid, $cid2orderid_mapping, $bem_vars, $matchedPhraseIds) = @_;
    my $report_uuid = HashingTools::generate_uuid();
    my $row_num = 0;
    for my $row (@{$bem_vars->{data_array}}) {
        my $report_row_hash = "${report_uuid}-${row_num}";
        $row->{report_row_hash} = $report_row_hash;
        my $cid = $row->{cid};
        my $row_for_log = {
            report_row_hash => $report_row_hash,
            cid => $cid,
            pid => $row->{adgroup_id},
            OrderID => $cid2orderid_mapping->{$cid}
        };
        $row_for_log->{PhraseID} = $row->{PhraseID} if defined($row->{PhraseID});
        $row_for_log->{Phrase} = $row->{phrase} if defined($row->{phrase});
        $row_for_log->{SimDistance} = $row->{sim_distance} if defined($row->{sim_distance});
        if (defined($row->{matched_phrase})) {
            $row_for_log->{MatchedPhrase} = $row->{matched_phrase};
            $row_for_log->{MatchedPhraseID} = ${$matchedPhraseIds}[$row_num];
        }
        $row_for_log->{UID} = $operator_uid;
        LogTools::log_messages("[export.okr.pzdrf_report_rows]", to_json($row_for_log));
        ++$row_num;
    }
}


1;
