package Apache::PPCLoginBox;
## no critic (TestingAndDebugging::RequireUseWarnings)

use strict;
use feature 'state';

use Encode ();
use File::Slurp;
use Template;
use Apache2::Const qw(:common);
use Apache2::RequestUtil;
use URI::Escape qw/uri_escape uri_escape_utf8 uri_unescape/;
use JSON;
use XML::LibXML qw//;

use Yandex::Blackbox;
use Yandex::Trace qw/current_trace/;
use Yandex::Template::Provider::Encoded;
use Yandex::HashUtils;
use Yandex::I18n;
use Yandex::DBTools;

use RBACElementary;
use RBAC2::Extended;
use RBAC2::DirectChecks;

use Property;
use Settings;
use IpTools;
use HttpTools;
use Tools;
use TextTools;
use EnvTools;
use TTTools;
use GeoTools;
use User;
use YandexOffice;
use Direct::ResponseHelper;
use Direct::Template;
use Campaign::Types;
use Client::ClientFeatures qw//;
use TvmChecker;

use utf8;

our $COMMANDER_PATH = $Settings::ROOT . '/../direct-commander';
our $COMMANDER_STAFF_PATH = $Settings::ROOT . '/../direct-commander-staff';

sub template_by_script_name {
    my $r = shift;
    my $is_direct = is_direct(http_server_host($r));
    my $uri = $r->uri || '';
    if ( !$is_direct ) {
        return "index_banner/index_banner.tt2";
    } elsif ($uri =~ /(commander)/) {
        # обрабатывается в bem, см. ниже функцию  print_LoginBox
        return "commander/commander.tt2";
    } else {
        return "index/index.tt2";
    }
}

sub is_commander {
    my $r = shift;
    return is_direct(http_server_host($r)) && ($r->uri || '') =~ /commander/;
}

sub handler
{
    my $r = Apache2::RequestUtil->request;
    binmode STDOUT, ':utf8';

    my $page = template_by_script_name($r);
    $page =~ s/\.html$//;
    $page =~ s/[^a-z0-9\_]//g;

    # пользователей, которые пришли на /o/, /u/ (могли остаться в закладках после эксперимента) -- редиректим на обычный адрес
    if ($page eq 'index' && ($r->uri||'') =~ m!/[on]/! ) {
        return redirect($r, "/".($r->args ? '?'.$r->args : ''));
    }

    my $trace = Yandex::Trace->new(service => 'direct.perl.web', method => $page);
    my $reqid = Yandex::Trace::trace_id();
    Direct::Template::save_dynamic_predefine({reqid => $reqid});
    Direct::Template::put_csp_nonce($reqid);
    set_response_csp_header($r, $reqid, 'PPCLoginBox', Direct::Template::get_csp_nonce($reqid));

    local $Yandex::TVM2::APP_ID;      $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{web};
    local $Yandex::TVM2::SECRET_PATH; $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{web};
    no warnings 'once';
    local $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER = \&TvmChecker::use_tvm;

    my ($session_id) = uri_unescape($r->headers_in->get('Cookie') =~ /Session_id=([^;]+)/);

    my $is_direct = is_direct(http_server_host($r));
    my $domain = yandex_domain($r);
    my ($tld) = $domain =~ /\.(\w+)$/xms;

    my $uatraits = HttpTools::get_uatraits($ENV{HTTP_USER_AGENT});
    my $vars = {
                    is_direct       => $is_direct,
                    yandex_domain   => $domain,
                    reqid           => $reqid,
                    uatraits        => $uatraits,
                    get_url         => sub {return TTTools::get_url('/registered/main.pl', undef, @_)},
                    passport_domain => get_passport_domain($r),
                    no_cookies_domain  => $Settings::NO_COOKIES_DOMAIN,
                    tune_secret_key => HttpTools::get_tune_secret_key($r, undef),
                    # шаблонизация мобильной морды
                    display_touch_page => $uatraits->{isMobile} && !$uatraits->{isTablet} && !is_commander($r),
                };

    state $another_phone_prop;
    $another_phone_prop //= Property->new('ANOTHER_PHONE_FOR_MAIN_PAGE');
    $vars->{another_phone_for_main_page} = $another_phone_prop->get(180) // 0;

    eval{
        $vars->{lang} = lang_auto_detect($r);
        Yandex::I18n::init_i18n($vars->{lang});

        my $region = { com => 'en' }->{$tld} || $tld;
        my $lang = $vars->{lang};
        $lang = 'uk'  if $lang eq 'ua';

        my $news_file = "$Settings::ROOT/data/t/news_${region}_$lang.json";
        $vars->{news} = from_json(scalar read_file($news_file, binmode => ':utf8'));
    };

    my $bb_res;
    my $noauth_expired = 0;
    my ($uid, $login, $email, $fio);
    if ($session_id) {
        eval {
            # blackbox request
            $bb_res = bb_sessionid($session_id, http_remote_ip($r), "direct.$domain"
                                  , [$BB_LOGIN, $BB_FIO], 'getdefault');
            if ($bb_res && $bb_res->{valid}) {
                $uid = $bb_res->{uid} || $bb_res->{liteuid};
                $login = $bb_res->{dbfield}{$BB_LOGIN};
                $vars->{display_name} = $bb_res->{display_name};
                $email = $bb_res->{default_email};
                $fio = $bb_res->{dbfield}{$BB_FIO};
            } elsif ($bb_res  && $bb_res->{status}{content} =~ /NOAUTH/i  && $bb_res->{age} > $NOAUTH_TIMEOUT ) {
                $noauth_expired = 1;
            }
        };
    }

    my $args = $r->args || '';
    my $uri = $r->uri || '/';
    my $yandexuid = get_cookie($r, 'yandexuid');
    $uri =~ s/^\/index\.html$/\//;

    hash_merge($vars, get_request_region_and_office($r));

    if ($page =~ /^index/) {
        if (!$r->headers_in->get('X-No-Promo-Landing')) {
            # кладем в new_promo_url адрес лендинга для заданных tld
            # если к tld нет подходящего лендинга - не будет отдачи страницы из КЛ и увидим мужика с дрелью
            if (exists($Settings::DIRECT_LANDING_PAGE_URL{$tld})) {
                $vars->{new_promo_url} = $Settings::DIRECT_LANDING_PAGE_URL{$tld};
            }
        }
    }

    if ($bb_res && $bb_res->{valid}) {
        #print STDERR "  ENTER PAGE:>>:\n";
        return print_Enter($r, $login, $uid, $email, $fio, $vars);
    } else {
        #print STDERR "  SIMPLE FACE:>>:\n";
        return print_LoginBox($r, $vars);
    }

    return(1);
}

#-------------------------------------------------------------------------------
# user not login
sub print_LoginBox($$)
{
    my ($r,$vars) = @_;

    my $new_promo_url = delete $vars->{new_promo_url};
    if ($new_promo_url) {
        return respond_accel_redirect($r, $new_promo_url);
    }

    my %FORM = parse_form();

    $vars->{FORM} = \%FORM;

    my $tmpl = template_by_script_name($r);
    if ($tmpl =~ /commander/) {
        _add_commander_version($r, $vars);
    }

    # XXX дублирование кода с print_Enter
    hash_merge $vars, _get_predefine($r, undef);

    if ($tmpl =~ m#^(?:index|commander)/#) {
        $vars->{index_page} = 1;
        return respond_bem($r, $vars->{reqid}, $vars,
            source => 'data3',
            ($vars->{display_touch_page} ? (bundle => 'direct_touch') : ()),
        );
    }

    my $template = _create_template($r);
    return respond_template($r, $template, $tmpl, $vars);
}

#-------------------------------------------------------------------------------
# on user login
# all vars $t_xxx for out to html
sub print_Enter($$$$$$)
{
    my ($r, $login, $uid, $email, $fio, $vars) = @_;

    my %FORM = parse_form();
    my $user_info;
    eval{
        $user_info = get_user_data($uid, [qw/ClientID is_developer/]);
    };

    my $rights;
    eval {
        my $rbac = RBAC2::Extended->get_singleton( $uid );
        rbac_login_check($rbac, {
            UID => $uid,
            user_info => hash_cut($user_info, qw/is_developer login/),
            is_internal_ip => is_internal_ip(http_remote_ip($r)),
        }, \$rights);
        $rights->{client_chief_uid} = rbac_get_chief_rep_of_client_rep($uid) if $uid;

        if ($rights->{client_chief_uid}) {
            $rights->{client_chief_login} = get_one_user_field($rights->{client_chief_uid}, 'login');
        }
    };

    my $tmpl = template_by_script_name($r);
    my $role = $rights->{role} || 'empty';

    hash_merge $vars, get_one_line_sql(PPC(uid => $rights->{client_chief_uid}), [
        "SELECT
            SUM(", {type => get_camp_kind_types("web_edit_base")}, ") as has_text_camps,
            SUM(", {type => get_camp_kind_types("media")}, ") as has_media_camps,
            SUM(", {type => get_camp_kind_types("web_edit_base"), archived => 'No'}, ") as live_camps_count
        FROM campaigns",
        WHERE => {
            statusEmpty__ne => 'Yes',
            uid => $rights->{client_chief_uid},
        },
    ]);

    $vars->{has_text_camps}   //= 0;
    $vars->{has_media_camps}  //= 0;
    $vars->{live_camps_count} //= 0;

    if (
        $tmpl eq 'index/index.tt2'
        && $role ne 'empty'
        && !($role eq 'client' && !$vars->{has_text_camps})
    ) {
        my $redir = {
            manager     => { cmd => 'showManagerMyClients' },
            agency      => { cmd => 'showClients' },
            client      => { cmd => 'showCamps' },
            internal_ad_admin => { cmd => 'showInternalAdsSearchPage' },
            internal_ad_manager => { cmd => 'showInternalAdsSearchPage' },
            internal_ad_superreader => { cmd => 'showInternalAdsSearchPage' },
        }->{$role}
        || { cmd => 'showSearchPage' };

        if ($role eq 'client' && $vars->{live_camps_count} == 1) {
            # Если у клиента только одна кампания - его должно отредиректить на страницу этой кампании.
            # Сбрасываем cmd, чтобы не дублировать здесь определение cid-а - правильный редирект сделает DoCmd.
            undef $redir->{cmd};
        }

        $redir->{$_} = $FORM{$_} for grep {/^utm_/} keys %FORM;
        return redirect($r, _get_predefine($r, $uid)->{SCRIPT}, $redir);
    }

    my $new_promo_url = delete $vars->{new_promo_url};	

    if ($new_promo_url) {
        my $uatraits = HttpTools::get_uatraits($ENV{HTTP_USER_AGENT});
        # если есть clientId, для мобильных под фичей уходим на advertize,
        # с которой может увести на создание кампании или на wizard/welcome,
        # а если это тачёвый клиент без кампаний с enable_uc_dna_user_choice и не daas, то покажем разводящую
        if (
            $uatraits->{isMobile}
            && !$uatraits->{isTablet}
            && $role eq 'client'
        ) {
            if ($vars->{has_text_camps} || ($FORM{retpath} // '' =~ /^\/daas/)
                || !Client::ClientFeatures::has_enable_uc_dna_user_choice($user_info->{ClientID})) {
                return redirect($r, _get_predefine($r, $uid)->{SCRIPT}, {cmd => 'advertize', mediaType => $FORM{mediaType}});
            } else {
                return redirect($r, '/wizard/flow/', {ulogin => $login});
            }
        }

        return respond_accel_redirect($r, $new_promo_url);
    }

    Tools::_save_vars($uid); # save for Tools::error

    $vars->{login_rights} = $rights;
    $vars->{uname}        = $login;
    $vars->{UID}          = $uid;
    $vars->{email}        = $email;
    $vars->{user_fio}     = $fio;
    $vars->{FORM}         = \%FORM;

    # respond_template вызывает process_bem для шапки, поэтому save_dynamic_predefine делается вне блока if
    hash_merge $vars, _get_predefine($r, $uid);

    # подставляем на страницу текущую версию Коммандера, прочитав ее из соотв. файла
    if ($tmpl =~ /commander/) {
        _add_commander_version($r, $vars);
    }

    if ($tmpl =~ m#^(?:index|commander)/#) {
        $vars->{index_page} = 1;
        return respond_bem($r, $vars->{reqid}, $vars,
            source => 'data3',
            ($vars->{display_touch_page}  ? (bundle => 'direct_touch') : ()),
        );
    }

    my $template = _create_template($r, $uid);
    return respond_template($r, $template, $tmpl, $vars);
}

sub _get_predefine {
    my $r = shift;
    my $uid = shift;

    my $SCRIPT_OBJECT = {
        protocol => http_server_scheme($r),
        host => http_server_host($r),
        path => "/registered/main.pl",
    };
    my $SCRIPT = "$SCRIPT_OBJECT->{protocol}://$SCRIPT_OBJECT->{host}$SCRIPT_OBJECT->{path}";

    return {
        is_beta        => is_beta(),
        is_production  => is_production(),

        script         => $SCRIPT,
        SCRIPT         => $SCRIPT,
        SCRIPT_OBJECT  => $SCRIPT_OBJECT,
        cur_page       => http_server_scheme($r).'://'.http_server_host($r).(($r->uri || '/') ne '/index.html' ? ($r->uri || '/') : '/').($r->args ? '?'.$r->args : ''),
        current_url       => uri_escape_utf8(($r->uri || '/').($r->args ? '?'.$r->args : '')),
        DOCUMENT_ROOT  => $ENV{DOCUMENT_ROOT},
        COOKIES        => get_all_cookies($r),
        CONFIGURATION  => $Settings::CONFIGURATION,

        help           => '/help/',
        scheme         => http_server_scheme($r),
        server_name    => http_server_host($r),
        ppcloginbox    => 1,
        tune_secret_key => HttpTools::get_tune_secret_key($r, $uid),

        # functions
        uri_escape     => \&URI::Escape::uri_escape_utf8,
        iget           => \&iget,
        get_geo_names  => \&GeoTools::get_geo_names,
        is_targeting_in_region => \&GeoTools::is_targeting_in_region,
        get_url        => sub {return TTTools::get_url('/registered/main.pl', undef, @_)},

        js_quote       => \&js_quote,
        js_encode      => \&js_quote,
        url_quote      => \&url_quote,
        generate_id    => \&TTTools::generate_id,
        is_string      => \&TTTools::is_string,
        json_dump      => sub {
                                  my $json_dump = to_json(@_, {allow_nonref => 1});
                                  $json_dump =~ s[/][\\/]g;
                                  return $json_dump;
                              },
        get_help_url  => \&Tools::get_help_url,
        svn_info      => TTTools::get_svn_info(),
        warn          => \&TTTools::server_warn,
        get_relative_url => sub {return TTTools::get_url('/registered/main.pl', undef, @_)},
    };
}

sub _create_template {
    my $r = shift;
    my $uid = shift;

    my $template = Template->new(
        PLUGIN_BASE => 'Yandex::Template::Plugin',
        LOAD_TEMPLATES => [ Yandex::Template::Provider::Encoded->new( encoding => 'utf8'
                                                                            , EVAL_PERL => 1
                                                                            , INCLUDE_PATH => $Settings::TT_INCLUDE_PATH
                                                                            , COMPILE_EXT  => '.ttc'
                                                                            , COMPILE_DIR  => "/tmp/tt-cache-$<"
                                                                            , INTERPOLATE  => 0 # expand "$var" in plain text
                                                                            , POST_CHOMP   => 1 # cleanup whitespace
                                                                            , )
                          ],
        PRE_DEFINE   => _get_predefine($r, $uid),
        FILTERS => {
            js  => \&js_quote,
            url => \&url_quote,
        },
    );
    return $template;
}

sub _add_commander_version {
    my $r = shift;
    my $vars = shift;
    my $fpath;
    $vars->{is_promo_commander} = 1;
    if ($r->uri =~ /commander-staff/) {
        $vars->{staff_commander} = 1;
        $fpath = $COMMANDER_STAFF_PATH . '/updateDescriptor.xml';
    } else {
        $fpath = $COMMANDER_PATH . '/updateDescriptor.xml';
    }
    if ( -r $fpath ) {
        eval {
            my $el = XML::LibXML->new()->load_xml(location => $fpath)->documentElement();
            my $xpc = XML::LibXML::XPathContext->new;
            $xpc->registerNs("x", $el->namespaceURI);
            for my $version_node (@{$xpc->find("/x:update/x:*/x:version", $el)}) {
                if (($version_node->textContent||'') =~ /^(\d+(\.\d+)?).*?$/) {
                    $vars->{"commander_version_".$version_node->parentNode->nodeName} = $1;
                }
            }
        };
        carp $@ if $@;
    }
}

#-------------------------------------------------------------------------------
#TODO проверить, возможно officecity и/или geo_region в действительности далее никем не используются - тогда можно удалять.
# данные о регионе пользователя и офис Яндекса, обслуживающий данный регион.
sub get_request_region_and_office
{
    my ($r) = @_;

    my $res = {};
    eval{
        my $region = http_geo_region($r);
        $res->{geo_region} = $region;
        my $yandex_domain = yandex_domain($r);
        $res->{officecity} = get_officecity_by_geo_footer($region, $yandex_domain);
    };

    return $res;
}
1;
