package PSGIApp::API::JSON;

# $Id$

=head1 NAME


=head1 DESCRIPTION

    Конструктор psgi-приложения для "большого" JSON-API Директа. 

=cut


use strict;
use warnings;

use Plack::Builder;
use Plack::Response;
use Plack::UTF8Request;
use Plack::NormalizeResponse;
use TvmChecker;

use API::JSON;

use utf8;

sub get_app
{
    # основное приложение
    my $app = sub {
        my $env = shift;

        my $r = Plack::UTF8Request->new($env);

        local $Yandex::TVM2::APP_ID;      $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{api};
        local $Yandex::TVM2::SECRET_PATH; $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{api};
        no warnings 'once';
        local $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER = \&TvmChecker::use_tvm;

        # reqid передается только для "видимости" в stacktrace'ах
        my $response = API::JSON::handler($r, reqid => $env->{reqid});

        my $normalized = Plack::NormalizeResponse::normalize($response);

        push @{$normalized->[1]}, @{$r->env->{extra_headers}} if @{$r->env->{extra_headers}//[]};
        push @{$normalized->[1]}, 'RequestId', $env->{reqid};
        
        return $normalized;
    };

    # набор оберток, характеризующий intapi
    # хорошо было бы профайлер тоже вынести в обертку, 
    # но пока непросто: придется использовать регексп в DetermineCmd, 
    # а для него нужна поддержка именованных захватывающих скобок
    return builder {
        enable 'MemLimit', limit => $Settings::SOAP_APACHE_MAX_PROC_SIZE;
        enable 'Trace', cmd_type => 'direct.json-api';
        enable 'SetAccelInfo';
        enable 'Sentry';
        $app;
    };
}


1;
