package PSGIApp::API::SOAP;

# $Id$

=head1 NAME


=head1 DESCRIPTION

    Конструктор psgi-приложения для "большого" SOAP-API Директа. 

=cut


use strict;
use warnings;

use Plack::Builder;
use Plack::Response;
use Plack::UTF8Request;
use Plack::NormalizeResponse;
use TvmChecker;

use SOAPAPI;

use utf8;

sub get_app
{
    # основное приложение
    my $app = sub {
        my $env = shift;

        my $r = Plack::UTF8Request->new($env);

        local $Yandex::TVM2::APP_ID;      $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{api};
        local $Yandex::TVM2::SECRET_PATH; $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{api};
        no warnings 'once';
        local $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER = \&TvmChecker::use_tvm;

        # reqid передается только для "видимости" в stacktrace'ах
        my $response = SOAPAPI::handler($r, reqid => $env->{reqid});

        my $normalized = Plack::NormalizeResponse::normalize($response);
        push @{$normalized->[1]}, 'RequestId', $env->{reqid};

        return $normalized;
    };

    # набор оберток, характеризующий api
    return builder {
        enable 'MemLimit', limit => $Settings::SOAP_APACHE_MAX_PROC_SIZE;
        enable 'Trace', cmd_type => 'direct.soap-api';
        enable 'SetAccelInfo';
        enable 'Sentry';
        $app;
    };
}


1;
