package PSGIApp::Export::Widget;

use strict;
use warnings;

use Plack::Builder;
use Plack::UTF8Request;

use Export::Widget;
use Settings;
use TvmChecker;

use utf8;

sub get_app {
    my $app = sub {
        my $env = shift;
        my $r = Plack::UTF8Request->new($env);

        local $Yandex::TVM2::APP_ID;      $Yandex::TVM2::APP_ID //= $Settings::TVM2_APP_ID{web};
        local $Yandex::TVM2::SECRET_PATH; $Yandex::TVM2::SECRET_PATH //= $Settings::TVM2_SECRET_PATH{web};
        no warnings 'once';
        local $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER //= \&TvmChecker::use_tvm;

        return Export::Widget::handler($r);
    };
    return builder {
        enable 'MemLimit', limit => $Settings::APACHE_MAX_PROC_SIZE;
        enable 'Trace', cmd_type => 'direct.export', cmd => 'Widget', use_headers => 1;
        $app;
    };
}

1;
