package PSGIApp::FeedBackCommander;

use strict;
use warnings;

use Plack::Builder;
use Plack::UTF8Request;

use FeedBackCommander;
use Settings;

use utf8;

sub get_app {
    my $app = sub {
        my $env = shift;
        my $r = Plack::UTF8Request->new($env);

        return FeedBackCommander::handler($r);
    };
    return builder {
        enable 'MemLimit', limit => $Settings::APACHE_MAX_PROC_SIZE;
        enable 'Reqid';
        $app;
    };
}

1;
