package PSGIApp::Intapi;

# $Id$

=head1 NAME


=head1 DESCRIPTION

    Конструктор psgi-приложения для разных "внутренних" API Директа. 

    * запускает команды, описанные в Intapi, с правильными параметрами;
    * оборачивает приложение во все необходимые обертки (middleware)
    * фильтрует список команд из Intapi по группе (group) -- для удобной генерации разных .psgi файлов, которые должны работать на разных серверах.

=cut


use strict;
use warnings;

use Plack::Builder;
use Plack::Response;
use Plack::UTF8Request;
use Plack::NormalizeResponse;
use TvmChecker;

use Intapi;
use EnvTools;

use utf8;

sub get_app
{
    my (%O) = @_;
    my $group = $O{group} || '';
    my $baseurl = $O{baseurl} || '';
    
    # secret-plaintext предназначен только для dev-серверов + ТС
    # и в production не работает
    if ( is_production() && $Intapi::GROUP_DISABLED_IN_PRODUCTION{$group} ) {
        return sub { die "$group is disabled in production" };
    }
    # основное приложение
    my $app = sub {
        my $env = shift;

        my $r = Plack::UTF8Request->new($env);
        my $multiform = Plack::UTF8Request->new($env)->parameters;

        local $Yandex::TVM2::APP_ID;      $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{intapi};
        local $Yandex::TVM2::SECRET_PATH; $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{intapi};
        no warnings 'once';
        local $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER = \&TvmChecker::use_tvm;

        my $response = Intapi::handler($r, $env->{cmd}, $multiform);
        if ($response and ref $response eq 'HASH' and $response->{reverse_proxy_redirect}) {
            #Поддержка reverse_proxy_redirect по аналогии с API
            return Plack::Response->new( 200, [
                'X-Accel-Redirect'  => $response->{reverse_proxy_redirect},
                'Content-Type'      => $response->{content_type},
            ], [] )->finalize;    
        }
        else {
            return Plack::NormalizeResponse::normalize($response);
        }
    };

    my @cmds = Intapi::get_group_cmds($group);
    my $urlmap = Intapi::make_urlmap($baseurl, @cmds);
    Intapi::cmd_require(@cmds);

    # набор оберток, характеризующий intapi
    return builder {
        enable 'MemLimit', limit => $Settings::APACHE_MAX_PROC_SIZE;
        enable 'DetermineCmd', urlmap => $urlmap;
        enable 'ExtractCmdParamsPlainIntapi';
        enable 'Trace', cmd_type => 'direct.intapi', use_headers => 1;
        enable 'Sentry';
        enable 'IntapiAutoLogger';
        enable 'ACL', networks_dir => $Settings::NETWORKS_DIR,
                      error_log => [log_file_name => 'intapi_check_acl_errors.log', date_suf => '%Y%m%d'];
        enable 'CheckTVM2Ticket', app_id => $Settings::TVM2_APP_ID{intapi}, tvmtool_token_file => $Settings::TVMTOOL_TOKEN_FILE;
        $app;
    };
}


1;
