package PdfReport;
## no critic (TestingAndDebugging::RequireUseWarnings)

=pod

    $Id$

    TODO: Здесь остался код только для чтения существующих и удаления старых BM-отчетов.
          Его нужно оторвать вместе с Reports::Offline::Broadmatch как только эти отчеты пропадут
    Про PDF отчеты - код построения живет в ppcPdfReports.pl, логика очереди - в PdfReport::Queue

=cut

use strict;
use utf8;

use Encode;
use HTTP::Request;

use Yandex::DBTools;
use Date::Calc;
use TextTools;

#use CairoGraph;
use Settings;
use Common qw/:subs/;
use List::Util qw/maxstr minstr/;
use YAML::Syck;
use Yandex::I18n;
use Yandex::ReportsXLS;
use Yandex::ReportsXLSX;
use Yandex::Compress;
use Yandex::HashUtils;
use Yandex::DateTime qw/date now/;
use Yandex::Validate;
use Yandex::ScalarUtils;
use Currency::Format;
use Campaign;
use LogTools;

use POSIX qw/strftime/;

our $MAX_REPORT_LIFETIME = 90; # через сколько дней после создания удалять

=head2 getBMReport
    
    Проверяет наличие готового BM отчёта на стороне Директа.

=cut

sub getBMReport($$) {
    my $uid = shift;
    my $id = shift;

    my $row = get_one_line_sql(PPC(uid => $uid), "
        SELECT id, bs_report_id, 
               date_from, date_to, 
               cids, uid, status ,create_time, ready_time, bm_data, status_no_data
          FROM bm_reports
         WHERE id=?
            ", $id);

    return undef unless defined $row->{bm_data};

    my $bm_data;
    eval{
        $bm_data = YAML::Syck::Load Encode::decode_utf8 inflate $row->{bm_data};
    };

    if($@) {
        LogTools::log_messages('pdf_reports', "Failed to load broadmatch report data: $@");
        return undef;
    }
    return $bm_data;
}
        
=head2 BMReport2Xls

    Формирует отчёт в формате XLS из BM отчёта

=cut

sub BMReport2Xls($) {
    my $opt = shift;

    # предполагается, что отчёт строится только по одному заказу
    die "invalid cids given: " . str($opt->{cids}) unless $opt->{cids} && ref($opt->{cids}) eq '' && is_valid_int($opt->{cids}, 0);

    my $vars = hash_merge {}, $opt;

    my $camp_info = get_camp_info($opt->{cids}, undef, short => 1);

    hash_copy $vars, $camp_info, qw/cid OrderID/;
    $vars->{cname} = $camp_info->{name};

    my $currency = $opt->{currency};
    die 'no currency known' unless $currency;

    my $data=[];
    
    my $xls_format = {
        sheetname=> iget("Доп. фразы"),
        set_row => [
#         {row => 7, height => 20},
#         {row => 8, height => 20},
        ],

        set_column => [
            {col1 => 0, count => 1, width => 15},
            {col1 => 1, count => 1, width => 40},
        ],

        merge_cells => [
#{row1 => 0, row2 => 0, col1 => 0, col2 => 4}
        ],
    };


    # когда в date_from/date_to приходит undef -- "Период" вообще не указываем (=="весь доступный период"). А что, если undef будет только в одной дате? 
    my $title = '';
    if (!$vars->{date_from} || !$vars->{date_to}){
        $title = iget('Кампания "%s" (№%s)', $vars->{cname}, $vars->{cid});
    } else {
        $title = iget('Кампания "%s" (№%s), период %s - %s', $vars->{cname}, $vars->{cid}, date($vars->{date_from})->strftime('%d.%m.%Y'), date($vars->{date_to})->strftime('%d.%m.%Y'));
    }
    push @$data, (
            [{data=>$title, format=>{bold=>1, size=>14}}],  
            [undef],
            [map {{data=>$_, format=>{bold=>1}}} iget('№ объявления'), iget('Текст объявления'), iget('Автоматически добавленные фразы'), iget('Клики'), iget('Расход, %s', format_currency($currency))],
        );

    my $banners_hash={};
    my $camp={};
    my @bm_data = grep { $_->{date} gt '20100806' } @{$vars->{bm_data}};
    my @bannerids = map { $_->{BannerID} } @bm_data;
    # TODO: картиночный баннер не может показаться по броадматчу?
    my $bannerid2data = get_hashes_hash_sql(PPC(cid => $vars->{cid}), ['select b.BannerID, b.bid, c.uid from banners b join campaigns c using (cid)', where => {'b.BannerID' => \@bannerids}]);
    for my $row (@bm_data) {
        my $banner;
        if ( exists $banners_hash->{$row->{BannerID}} ) {
            $banner = $banners_hash->{$row->{BannerID}};
        } else {
            my $banner_data = $bannerid2data->{$row->{BannerID}};
            next unless $banner_data;

            $banner = $banners_hash->{$row->{BannerID}} = get_user_banner($banner_data->{uid}, $banner_data->{bid}, {skip_bs_prices => 1});
            
            html2string($banner->{title});
            html2string($banner->{body});
            delete $banner->{phrases};

            if ( $banner->{phone} ) {
                $banner->{phone} =~ s/\#/ /g;
            }
        }

        my $phrase = $banner->{phrases_hash}{$row->{phrase}} ||= {};
        $phrase->{phrase} = $row->{phrase};
        for my $key (qw/cost clicks/ ) {
            $phrase->{$key} += $row->{$key};
        }
    }


    $vars->{banners} = [ sort {$a->{bid} <=> $b->{bid}} values %$banners_hash ];
    
    for my $banner (@{$vars->{banners}}){
        $banner->{phrases} = [sort {$a->{phrase} cmp $b->{phrase}} values %{$banner->{phrases_hash}}];
        delete $banner->{phrases_hash};
        
        for my $phrase (@{$banner->{phrases}}) {
            for my $key (qw/cost clicks/ ) {
                ($banner->{$key}||=0) += $phrase->{$key};
            }
        }

        for my $key (qw/cost clicks/ ) {
            ($camp->{$key}||=0) += $banner->{$key};
        }
    }

    for my $banner (@{$vars->{banners}}) {

        my @banner_data;
        push @banner_data,
            [undef], 
            [iget('М-%d', $banner->{bid}), {data=>$banner->{title}, format=>{bold=>1}}],
            [undef, $banner->{body}],
            grep {defined $_} (
                $banner->{href}  ? [undef, $banner->{href} ] : undef,
#                $banner->{phone} ? [undef, $banner->{phone}] : undef,
            )
            ;

        my $line_id = 1;
        for my $p  (@{$banner->{phrases}}) {
            while ($line_id > $#banner_data) {
                push @banner_data, [undef, undef];
            }
            push @{$banner_data[$line_id]}, $p->{phrase}, $p->{clicks}, sprintf("%.2f", $p->{cost}*$opt->{multiplier});

            $line_id++;
        }  

        push @banner_data,
            [undef],
            [undef, undef, {data=>iget('Итого по объявлению:'), format=>{bold=>1}}, {data=>$banner->{clicks}, format=>{bold=>1}}, {data=>sprintf("%.2f", $banner->{cost}*$opt->{multiplier}), format=>{bold=>1}},];

        push @$data, @banner_data;
    }

    push @$data,
        [undef],
        [undef, undef, {data=>iget('Всего по кампании:'), format=>{bold=>1}}, {data=>$camp->{clicks}, format=>{bold=>1}}, {data=>sprintf("%.2f", $camp->{cost}*$opt->{multiplier}), format=>{bold=>1}},];

    

    my $xls = Yandex::ReportsXLS->new()->array2excel2scalar(
        [$data],
        [$xls_format],
    );

    return $xls;
}

=head2 clearOldBMReports

    удаляет BM отчёты старше 3х месяцев

=cut

sub clearOldBMReports {
    my %opt = @_;
    do_sql(PPC(shard => $opt{shard}), "
        DELETE from bm_reports where create_time < NOW() - INTERVAL $MAX_REPORT_LIFETIME DAY
            ");
}

1;
