package PdfTools;
## no critic (TestingAndDebugging::RequireUseWarnings)

# $Id$

=head1 NAME

    PdfTools - функции по работе с pdf-файлами

=head1 DESCRIPTION


=cut

use strict;
use utf8;

use PDF::API2;

=head2 set_pdf_cs_rgba

    Добавляет в PDF-файл информацию о цветовой схеме
    Без этого сгенерированный pdf может отображаться с чёрным фоном в AcrobatReader 8.0 и выше.

=cut
sub set_pdf_cs_rgba {
    my $pdf = PDF::API2->new;
    $pdf = PDF::API2->openScalar(shift) or die "Can't load pdfstream:$@:$!\n";

    for ( my $i=1;; $i++) {
        my $page = $pdf->openpage($i) or last;
        # Add missing attribute if PDFLatex forget
        $page->{Group} ||= bless(
          { 'CS' => bless( {
                          ' realised' => 1,
                          'val' => 'DeviceRGB'}, 
                    'PDF::API2::Basic::PDF::Name'),
             'S' => bless( {
                          ' realised' => 1,
                          'val' => 'Transparency'}, 
                    'PDF::API2::Basic::PDF::Name'),
             'Type' => bless( {
                          ' realised' => 1,
                          'val' => 'Group'}, 
                    'PDF::API2::Basic::PDF::Name'),
             ' realised' => 1
          }, 
          'PDF::API2::Basic::PDF::Dict');
    }

    return $pdf->stringify;
}

1;
