package Plack::Middleware::Direct::LogCmd;

use base qw/Plack::Middleware/;
use Plack::Util::Accessor qw/email subject/;

=head1 NAME

    Plack::Middleware::Direct::LogCmd

=head1 DESCRIPTION

    Директ-специфик
    запись информации о запросе в logcmd_XXX

=cut


use strict;
use warnings;

use Time::HiRes;

use Plack::UTF8Request;

use HttpTools qw/multiform2directform/;
use Tools qw/log_cmd/;

use utf8;

=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;

    my $current_time = Time::HiRes::time();
    my $cpu_user_time = (times())[0];

    my $FORM_FOR_LOGS = multiform2directform(
        Plack::UTF8Request->new($env)->parameters
        );

    my $response = $self->app->($env);

    $FORM_FOR_LOGS->{_logtime} = $current_time;
    $FORM_FOR_LOGS->{_runtime} = Time::HiRes::time() - $current_time;
    $FORM_FOR_LOGS->{_http_status} = $response->[0];
    $FORM_FOR_LOGS->{_cpu_user_time} = (times())[0] - $cpu_user_time;
    
    if ($env->{cmd}) {
        # а вдруг, был "внутренний" редирект
        $FORM_FOR_LOGS->{cmd} = $env->{cmd};        
    }
    
    log_cmd($FORM_FOR_LOGS);
    
    return $response;
}

1;
