package Plack::Middleware::ExtractCmdParamsPlainIntapi;
use strict;
use warnings;

=head1 NAME

    Plack::Middleware::ExtractCmdParamsPlainIntapi

=head1 DESCRIPTION

    заполняет $env->{cmd_params} для простых intapi-ручек (не jsonrpc)
    cmd_params используются другими middleware типа ACL


=cut

use parent 'Plack::Middleware';

use Yandex::Clone qw/yclone/;

use Plack::UTF8Request;

use Intapi;
use EnvTools;

=head1 SUBROUTINES/METHODS

=head2 call

=cut

sub call {
    my ( $self, $env ) = @_;

    return $self->app->(_prepare_env($env));
}

sub _prepare_env {
    my $env = shift;

    my $cmd = $env->{cmd};

    $env->{cmd_params} = ref $Intapi::cmd{$cmd} ? yclone($Intapi::cmd{$cmd}) : {};

    my $names_dict = {
        allow_to => {
            testing         => "allow_to_in_testing"
        },

        tvm2_allow_ids => {
            testing         => "tvm2_allow_ids_in_testing",
            sandbox         => "tvm2_allow_ids_sandbox",
            sandbox_testing => "tvm2_allow_ids_sandbox_in_testing"
        },

        skip_tvm2_check => {
            testing         => "skip_tvm2_check_in_testing",
            sandbox         => "skip_tvm2_check_sandbox",
            sandbox_testing => "skip_tvm2_check_sandbox_in_testing"
        }
    };

    my $prod = is_production();
    my $sb = is_sandbox();

    foreach my $field  (keys %$names_dict) {

        my $cmd_params = $env->{cmd_params};
        my $names = $names_dict->{$field};

        # наша цель - заполнить $cmd_params->{$field} нужными значениями в зависимости от того в какой конфигурации мы работаем
        # (хотим заполнить $cmd_params->{$field}, потому что именно оно будет потом использоваться вне зависимости от конфигурации)

        # понимаем, откуда брать значения
        my $env_key = join ("_",
            ($sb && exists($names->{sandbox}) ? "sandbox" : ()),
            ($prod ? () : "testing"));

        my $source = $names->{$env_key};


        # если не прод
        if (defined($source)) {
            # удаляем продовое значение, потому что мы его заполним ниже
            # (или не заполним в зависимости от наличия поля для данной конфигурации)
            delete $cmd_params->{$field};

            if (exists $cmd_params->{$source}) {
                # у нас есть значение для тестинга, копируем его в продовое
                $cmd_params->{$field} = $cmd_params->{$source};
            }
        }

        # удаляем все непродовое, чтобы оно случайно некорректно не заиспользовалось
        delete @{$cmd_params}{ values %$names };
    }

    return $env;
}

1;
