package Plack::Middleware::ExtractJsonrpcResource;
use base qw/Plack::Middleware/;

#use Plack::Util::Accessor qw/cmd_params/;

=head1 NAME


=head1 DESCRIPTION

=cut


use strict;
use warnings;

use Plack::UTF8Request;

use Yandex::HashUtils;

use Intapi;

use utf8;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;
    my $r = Plack::UTF8Request->new($env);
    my @segments = split '/', $r->path;
    my $resource = $segments[-1] || '';
    $env->{resource} = $resource;

    my $jsonrpc_method;
    if ($r->method eq "GET") {
        $jsonrpc_method = $r->parameters->{method};
    } elsif ($r->method eq "POST") {
        if ($r->content =~ m/"method"\s*:\s*"(.+?)"/) {
            $jsonrpc_method = $1;
        }
    }
    $jsonrpc_method ||= 'unknown';

    $env->{cmd} = $resource . '_' . $jsonrpc_method;

    $env->{cmd_params} ||= {};
    hash_merge $env->{cmd_params}, $self->{cmd_params}{$resource} || {};
    my $result = $self->app->($env);
    return $result;
}

1;
