package Plack::Middleware::JsonrpcLogger;
use strict;
use warnings;

=head1 NAME

    Plack::Middleware::JsonrpcLogger

=head1 DESCRIPTION

    Логгирует запросы в Intapi в syslog. Этот модуль логгирует запросы только jsonrpc-ручкам, для
    остальных есть IntapiAutoLogger.

=cut

use parent 'Plack::Middleware';

use JSON::RPC::Parser;

use Plack::UTF8Request;

use Intapi;

=head1 SUBROUTINES/METHODS

=head2 call

=cut

sub call {
    my ( $self, $env ) = @_;

    my $cmd = $env->{resource} || 'unknown';
    my $cmd_spec = $cmd && exists $Intapi::cmd{$cmd} ? $Intapi::cmd{$cmd} : undef;

    return $self->app->($env) if $cmd_spec && $cmd_spec->{custom_log};

    my $log = Intapi::request_logger($cmd);

    my $req = Plack::UTF8Request->new($env);
    my $procs = JSON::RPC::Parser->new( coder => JSON->new )->construct_from_req($req);

    my $procs_dump;
    if ( ref $procs eq 'ARRAY' ) {
        $procs_dump = [ map { _dump_proc($_) } @$procs ];
    } else {
        $procs_dump = _dump_proc($procs);
    }

    $log->out( { reqid => Yandex::Trace::trace_id(), procs => $procs_dump } );

    my $result = $self->app->($env);

    if ($cmd_spec->{log_response}) {
        $log->out( { reqid => Yandex::Trace::trace_id(), status => $result->[0], response => $result->[2][0] } );
    }

    return $result;
}

=head2 _dump_proc

    Превращает данные вызова JSONRPC (JSON::RPC::Procedure) в структуру, которую можно задампить в JSON
    и положить в лог.

=cut

sub _dump_proc {
    my ($proc) = @_;
    return { map { $_ => $proc->$_ } qw( id method params ) };
}

1;
