package Plack::Middleware::Sentry;
use base qw/Plack::Middleware/;

# $Id: MailFatals.pm 1087 2012-02-09 16:00:02Z oregano $

=head1 NAME

    Plack::Middleware::Sentry

=head1 DESCRIPTION

    Отправка 500-ых ошибок в Sentry

=cut


use Direct::Modern;

use SentryTools qw//;
use LogTools qw//;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;

    my $response = eval {
        local $Carp::MaxArgLen = 4096;
        local $SIG{__DIE__} = SentryTools::prepare_die_handler();
    
        $self->app->($env);
    };
    my $err = $@;
    
    if ($err || (ref $response eq 'ARRAY' && $response->[0] >= 500)) {
        LogTools::log_messages("500-error", SentryTools::get_last_error().": ".SentryTools::get_last_stacktrace());
        # пишем в Sentry
        SentryTools::send_last_exception(SentryTools::get_last_error(),
                skip => [qw/main Try::Tiny API::JSON Intapi SOAPAPI/],
                skip_re => [qr|^Plack::|, qr|^SOAP::Transport::|]);
    }
    die $err if $err;

    return $response;
}

1;
