package Plack::Middleware::SetAccelInfo;

=head1 NAME

    Plack::Middleware::SetAccelInfo - добавляет в ответ заголовок X-Accel-Info

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use Plack::Util;

use parent qw( Plack::Middleware );

sub call {
    my ($self, $env) = @_;
    my $res = $self->app->($env);
    $self->response_cb($res, sub {
        my $res = shift;
        my @info;
        if ($env->{reqid}) {
            push @info, "reqid:$env->{reqid}";
        }
        if ($env->{trace}) {
            push @info, "cmd:".$env->{trace}->service . '/' . $env->{trace}->method();
        }
        if (defined $env->{appcode}) {
            push @info, "appcode:".$env->{appcode};
        }
        if (@info) {
            Plack::Util::header_set($res->[1], 'X-Accel-Info', join(',', @info));
        }
    });
}

1;
