package Reports::Offline::Broadmatch;

=head2 DESCRIPTION

    Формализованная обёртка для отчётов по автоматически добавленным фразам

    TODO: Здесь остался только код для получения отчетов из базы.
    Когда в базе таких отчетов не останется, код нужно будет удалить вместе с PdfReport.pm

=cut

use Direct::Modern;
use Mouse;

use Yandex::I18n;
use Yandex::DateTime qw/ date /;
use Yandex::DBTools;
use Yandex::HashUtils qw/ hash_copy /;

use PdfReport;

use Settings;


=head2 validate_params

Проверка параметров перед созданием отчёта

=cut

sub validate_params {
    die "New broadmatch report cannot be ordered";
}


=head2 place_order

Помещение отчёта в очередь на расчёт

=cut

sub place_order {
    die "New broadmatch report cannot be ordered";
}


=head2 requeue_order($uid, $id)

Перезапрос отчёта

=cut

sub requeue_order {
    die "New broadmatch report cannot be ordered";
}


=head2 get_list($uid)

Возвращает список отчётов пользователя

=cut

sub get_list {
    my ($self, $uid) = @_;

    my $reports = get_all_sql(PPC(uid => $uid),
        "SELECT id, cids, date_from, date_to, status, status_no_data,
            ready_time, create_time, 'day' as `group`, is_fail
        FROM bm_reports
        WHERE uid=?
        ORDER BY id DESC",
        $uid,
    );

    return $reports;
}


=head2 get_data($uid, $id)

Возвращает файл с отчётом

=cut

sub get_data {
    my ($self, $uid, $id) = @_;

    my $opt = get_one_line_sql(PPC(uid => $uid),
        "SELECT id, bs_report_id, cids, uid, date_from, date_to
        FROM bm_reports
        WHERE uid=? AND id=? AND status_no_data='No' AND status='ready'",
        $uid, $id,
    );

    my $saved_report = PdfReport::getBMReport($uid, $opt->{id});
    return if !$saved_report;

    if (ref($saved_report) eq 'ARRAY') {
        # домультивалютный формат: в отчёте сразу массив со строками отчёта
        $opt->{bm_data} = $saved_report;
        $opt->{currency} = 'YND_FIXED';
        $opt->{multiplier} = 1e-6;
    } elsif (ref($saved_report) eq 'HASH') {
        # постмультивалютный формат: {bm_data => [{<строки отчёта>, ...}], currency => <валюта>}
        hash_copy $opt, $saved_report, qw/bm_data currency/;
        $opt->{multiplier} = 1;
    }

    my $report_file = PdfReport::BMReport2Xls($opt);
    # TODO: использовать $Reports::MIMETypes::type2mime{xls}
    return 'application/xls' => $report_file;
}


=head2 delete_data($uid, $id)

Удаляет файл с отчётом

=cut

sub delete_data {
    my ($self, $uid, $id) = @_;

    do_delete_from_table(PPC(uid => $uid), 'bm_reports',
        where => { uid => $uid, id => $id },
    );

    return;
}

__PACKAGE__->meta->make_immutable;
1;
