package Reports::Offline::Pdf;

=head2 DESCRIPTION

Формализованная обёртка для PDF-отчётов.

=cut

use Direct::Modern;
use Mouse;

use Yandex::I18n;

use PdfReport::Queue;
use Reports::MIMETypes;

=head2 validate_params

Проверка параметров перед созданием отчёта

=cut

sub validate_params {
    my ($self, $vars) = @_;

    my @errors;

    my $queue_length = PdfReport::Queue::getPDFQueueLength($vars->{uid});
    push @errors, iget("Невозможно заказать более %s отчётов одновременно. Пожалуйста, дождитесь готовности хотя бы одного отчёта.", $PdfReport::Queue::MAX_QUEUE_LENGTH) if $queue_length >= $PdfReport::Queue::MAX_QUEUE_LENGTH;

    return @errors;
}


=head2 place_order

Помещение отчёта в очередь на расчёт

=cut

sub place_order {
    my ($self, $vars) = @_;

    return PdfReport::Queue::pushReportOrder($vars);
}


=head2 requeue_order($uid, $id)

Перезапрос отчёта

=cut

sub requeue_order {
    my ($self, $uid, $id) = @_;

    return PdfReport::Queue::requeue_order($uid, $id);
}


=head2 get_list($uid)

Возвращает список отчётов пользователя

=cut

sub get_list {
    my ($self, $uid) = @_;

    return PdfReport::Queue::get_list($uid);
}


=head2 get_data($uid, $id)

Возвращает файл с отчётом

=cut

sub get_data {
    my ($self, $uid, $id) = @_;

    my $rep_data_ref = PdfReport::Queue::get_data($uid, $id);

    return if !$rep_data_ref;
    return $Reports::MIMETypes::type2mime{pdf} => $$rep_data_ref;
}


=head2 delete_data($uid, $id)

Удаляет файл с отчётом

=cut

sub delete_data {
    my ($self, $uid, $id) = @_;

    return PdfReport::Queue::delete_data($uid, $id);
}

__PACKAGE__->meta->make_immutable;
1;

