package Reports::Offline::TextWriter;

# $Id$

use strict;
use warnings;

use base qw/Exporter/;
our @EXPORT_OK = qw/
    buffered_write_lines
/;

=encoding utf-8

=head1 NAME

Reports::Offline::TextWriter - запись строк в файл

=head1 DESCRIPTION

Модуль предоставляет функцию для записи строк из coderef-генератора через стандартный разделитель (CRLF) с накоплением в буфер
flush остаётся на усмотрение интерпретатора

=cut

=head2 $buf_lines

Сколько строк передавать в print

=cut

our $buf_lines = 2_500;

=head2 buffered_write_lines(row_gen, header, file)

Брать несколько строк из row_gen и писать их в файл. Сначала записать заголовок, если он определён.
file должен поддерживать метод filehandle, возвращающий открытый хендл с указанными параметрами (см. Path::Tiny)

=cut

sub buffered_write_lines {
    my ($row_gen, $header, $file) = @_;
    my $handle = $file->filehandle('>', ':raw:encoding(UTF-8)');

    if (defined $header) {
        print $handle $header."\r\n";
    }

    my $has_data = 1;
    while ($has_data) {
        my @lines;
        foreach (1..$buf_lines) {
            my $line = &$row_gen();
            unless (defined $line) {
                $has_data = 0;
                last;
            }
            push @lines, $line;
        }

        unless (@lines) { # данных вообще нет
            $has_data = 0;
            last;
        }

        my $buf = join "\r\n", @lines;
        print $handle $buf."\r\n";

        unless (scalar @lines == $buf_lines) { # данные были, но их уже нет
            $has_data = 0;
            last;
        }
    }

    close $handle;
    return;
}

1;
