package Reports::Offline::Video;

=head2 DESCRIPTION


=cut

use Settings;

use Direct::Modern;
use Mouse;

use Yandex::I18n;

use Yandex::DBShards qw/get_new_id/;
use Yandex::DBTools;
use Yandex::DBQueue;
use Yandex::TimeCommon qw/unix2mysql unix2human mysql2unix/;
use PrimitivesIds qw/get_clientid get_orderids get_bannerids get_cids/;
use TextTools qw/get_num_array_by_str/;
use Direct::Storage;

use Reports::MIMETypes;

# начиная с этого дня доступна статистика
my $VIDEO_REPORT_MIN_DATE = '20180401';

=head2 validate_params

Проверка параметров перед созданием отчёта

=cut

sub validate_params {
    my ($self, $vars) = @_;

    my @errors;
    
    my $min_date_ts = mysql2unix($VIDEO_REPORT_MIN_DATE);
    my $date_from_ts = $vars->{date_from} ? mysql2unix($vars->{date_from}) : undef;

    if (defined $date_from_ts && $date_from_ts < $min_date_ts) {
        push @errors, iget("Статистика по видеодополнениям доступна только с %s", unix2human($min_date_ts));
    }

    if ($vars->{bids}) {
        my $bids = get_num_array_by_str($vars->{bids});
        if (!@$bids) {
            push @errors, iget("Указаны некорректные номера баннеров");
        }
    }

    if ($vars->{goals}) {
        my $goals = get_num_array_by_str($vars->{goals});
        if (!$goals) {
            push @errors, iget("Указаны некорректные цели");
        }
    }

    if ($vars->{campaign_type} && $vars->{campaign_type} !~ /^text|dynamic|mobile_content|performance|mcbanner$/) {
        push @errors, iget("Указан некорректный тип кампании");
    }

    if ($vars->{banner_type} && $vars->{banner_type} !~ /^text|image_ad|other$/) {
        push @errors, iget("Указан некорректный тип баннера");
    }

    return @errors;
}


=head2 place_order

Помещение отчёта в очередь на расчёт

=cut

sub place_order {
    my ($self, $vars) = @_;
    
    $vars->{report_name} = iget("Отчет по видео-дополнениям");

    my %param_group_by = map { $_ => 1 } split /\s*,\s*/, $vars->{group_by};

    my $params = {};
    
    my %group_by;

    my @cids;
    if ($vars->{cids}) {
        if (ref $vars->{cids} eq 'ARRAY') {
            @cids = @{$vars->{cids}};
        }
        else {
            @cids = @{get_num_array_by_str($vars->{cids})};
        }
        $group_by{OrderID} = 1;
    }
    else {
        @cids = @{get_cids(ClientID => $vars->{ClientID})};
    }
    $vars->{cids} = \@cids;

    $params->{order_ids} = get_orderids(cid => \@cids);

    if ($vars->{bids}) {
        $params->{filters_pre}->{BannerID}->{eq} = get_bannerids(bid => get_num_array_by_str($vars->{bids}));
        $group_by{BannerID} = 1;
    }
    if ($param_group_by{banner}) {
        $group_by{BannerID} = 1;
    }

    if ($vars->{goals}) {
        $params->{filters_pre}->{GoalID}->{eq} = get_num_array_by_str($vars->{goals});
        $group_by{GoalID} = 1;
    }

    $group_by{VdCategory} = 1;

    $params->{group_by} = [ grep { $group_by{$_} } qw/GoalID OrderID BannerID UpdateTime VdCategory/ ];
    $params->{order_by} = [ map { { field => $_ } } grep { $group_by{$_} } qw/GoalID OrderID UpdateTime/ ];


    $params->{countable_fields} = [ "Shows", "Clicks", "VdShows", "VdClicks", "GoalsNum", "Cost", "ConversionRate" ];
    if (!defined $vars->{date_from}) {
        $params->{date_from} = get_one_field_sql(PPC(ClientID => $vars->{ClientID}), [
            'select min(start_time) from campaigns', where => { cid => \@cids } ]
        );
        my $min_date_ts = mysql2unix($VIDEO_REPORT_MIN_DATE);
        if (mysql2unix($params->{date_from}) < $min_date_ts) {
            $params->{date_from} = unix2human($min_date_ts, '%Y-%m-%d');
        }
        $params->{date_to} = unix2human(time(), '%Y-%m-%d');
        $vars->{date_to} = $params->{date_to};
        $vars->{date_from} = $params->{date_from};
    } else {
        $params->{date_from} = unix2human(mysql2unix($vars->{date_from}), '%Y-%m-%d');
        $params->{date_to} = unix2human(mysql2unix($vars->{date_to}), '%Y-%m-%d');
    }

    delete $vars->{camps};

    $vars->{params} = $params;

    my $queue = Yandex::DBQueue->new(PPC(ClientID => $vars->{ClientID}), 'video_stat_report');
    my $job_id = get_new_id('job_id');
    $vars->{report_name} .= " $job_id";
    
    my $job = $queue->insert_job({
        job_id => $job_id,
        uid => $vars->{uid},
        ClientID => $vars->{ClientID},
        args => $vars,
    });
}


=head2 requeue_order($uid, $id)

Перезапрос отчёта

=cut

sub requeue_order {
    my ($self, $uid, $id) = @_;

    return;
}


=head2 get_list($uid)

Возвращает список отчётов пользователя

=cut

sub get_list {
    my ($self, $uid) = @_;
    
    my $client_id = get_clientid(uid => $uid);
    my $queue = Yandex::DBQueue->new(PPC(ClientID => $client_id), 'video_stat_report');
    my $jobs = $queue->find_jobs(ClientID => $client_id, status__not_in => ['Revoked']);
    my $reports = [];
    
    my %status = (
        New => 'new',
        Grabbed => 'processing',
        Finished => 'ready',
        Failed => undef,
    );

    for my $job (@$jobs) {
        push @$reports, {
            cids => (join ',', @{$job->args->{cids}//[]}),
            create_time => $job->create_time,
            date_from => unix2human(mysql2unix($job->args->{date_from}), '%Y-%m-%d'),
            date_to => unix2human(mysql2unix($job->args->{date_to}), '%Y-%m-%d'),
            group => $job->args->{group_by} || 'day',
            is_fail => $job->status eq 'Failed',
            id => $job->job_id,
            ready_time => $job->create_time,
            # ready_time => '0000-00-00 00:00:00',
            report_name => $job->args->{report_name},
            status => $status{$job->status},
            report_type => $job->args->{report_type},
            type => 'video',
        };
    }
    return $reports;
}


=head2 get_data($uid, $id)

Возвращает файл с отчётом

=cut

sub get_data {
    my ($self, $uid, $id) = @_;

    my $storage = Direct::Storage->new();
    my $queue = Yandex::DBQueue->new(PPC(uid => $uid), 'video_stat_report');
    my $jobs = $queue->find_jobs(ClientID => get_clientid(uid => $uid), job_id => [$id]);
    unless (@$jobs) {
        die "report not found";
    }

    my $filename = $jobs->[0]->result->{path};

    return $Reports::MIMETypes::type2mime{xlsx} => $storage->get_file('offline_stat_reports', ClientID => get_clientid(uid => $uid), filename => $filename)->content();
}


=head2 delete_data($uid, $id)

Удаляет файл с отчётом

=cut

sub delete_data {
    my ($self, $uid, $id) = @_;
    
    my $queue = Yandex::DBQueue->new(PPC(uid => $uid), 'video_stat_report');
    my $jobs = $queue->find_jobs(ClientID => get_clientid(uid => $uid), job_id => [$id]);
    $_->mark_revoked() for @$jobs;
    return @$jobs;
}

__PACKAGE__->meta->make_immutable;
1;


