package Reports::Offline::Xls;

=head2 DESCRIPTION

XLS-отчёты.

Только методы для работы с каталогом

=cut



use Direct::Modern;
use Carp;
use Mouse;

use Yandex::I18n;
use Yandex::DateTime qw/ date now /;
use Yandex::DBTools;
use Direct::Storage;

use CampStat;

use Settings;



=head2 validate_params

STUB: Проверка параметров перед созданием отчёта

=cut

sub validate_params {
    my ($self, $vars) = @_;
    croak "Validation is not supported";
#    return;
}


=head2 place_order

STUB: Помещение отчёта в очередь на расчёт

=cut

sub place_order {
    my ($self, $vars) = @_;
    croak "Ordering is not supported";
#    return;
}

=head2 requeue_order($uid, $id)

Перезапрос отчёта

=cut

sub requeue_order {
    my ($self, $uid, $id) = @_;

    do_update_table(PPCDICT, 'xls_reports',
        { status => 'new', retries => 0, ready_time => undef },
        where => { uid => $uid, id => $id },
    );

    return;
}


=head2 get_list($uid)

STUB: Возвращает список отчётов пользователя

=cut

sub get_list {
    my ($self, $uid) = @_;
    croak "Getting list is not supported";
#    return [];
}


=head2 get_data($uid, $id)

Возвращает файл с отчётом

=cut

sub get_data {
    my ($self, $uid, $id) = @_;

    my $report_file_name = get_one_field_sql(PPCDICT,
        "SELECT report_name
        FROM xls_reports
        WHERE id=? AND uid=? AND status IN (?,?)",
        $id, $uid, CampStat::STATUS_READY, CampStat::STATUS_OPENED,
    );

    return (undef, undef) unless $report_file_name;
    
    my $storage = Direct::Storage->new();
    my $file = $storage->get_file('xls_reports', filename => $report_file_name, uid => $uid);

    return (undef, undef) unless $file;

    do_sql(PPCDICT,
        "UPDATE xls_reports SET status = ? WHERE id = ?",
        CampStat::STATUS_OPENED, $id
    );

    my $file_type = ( $report_file_name =~ /\.([^\.]+)?$/ ) ? $1 : 'xls';
    return ":$file_type" => $file->content;
}


=head2 delete_data($uid, $id)

Удаляет файл с отчётом

=cut

sub delete_data {
    my ($self, $uid, $id) = @_;

    my $filename = get_one_field_sql(PPCDICT, "select report_name from xls_reports where id = ?", $id);
    do_delete_from_table(PPCDICT, 'xls_reports',
        where => { uid => $uid, id => $id },
    );
    my $storage = Direct::Storage->new();
    $storage->delete_file('xls_reports', filename => $filename, uid => $uid);

    return;
}

__PACKAGE__->meta->make_immutable;
1;

