package ReqWizard;

use Direct::Modern;

use LogTools;
use JSON;
use Carp;
use Yandex::HTTP;
use List::Util qw/any sum0/;
use Settings;
use Tools qw//;

=head2 reqwizard_call($request)

Вызвать метод reqwirard c логированием

=cut

sub reqwizard_call {
    my ($phrases) = @_;

    my $id = 0;
    my %reqs;
    my $base_url = $Settings::REQ_WIZARD_URL;
    for my $phrase (@$phrases) {
        my $params = {
            text => $phrase, format => 'json', wizclient => 'advq'
        };
        $reqs{$id} = { url => Yandex::HTTP::make_url($base_url, $params)};
        $id++;
    }

    my $reqs_num = scalar keys %reqs;
    my $response = Yandex::HTTP::http_parallel_request(
        GET => \%reqs,
        max_req => 10,
        timeout => 60,
        num_attempts => 3,
        max_total_retries => 3 + int(0.5 * $reqs_num),
        soft_timeout => 1.5,
    );
    my $result = [];
    foreach my $resp (values %$response) {
        if (!$resp->{is_success}) {
            LogTools::log_messages("reqwizard", to_json({request_phrases => $phrases, resp => $response}));
            croak "error getting data from $base_url";
        }
        my @res = map {[$_->{Phrase}, $_->{Score}]} @{JSON::from_json($resp->{content}, {utf8  => 1})->{synonyms}};
        push @$result, \@res;
    }
    return $result;
}

1;
