package SOAPAPI;

use strict;
use warnings;

use Settings;
use API;
use APICommon qw(:subs);

use SOAP::Lite;
use SOAP::Transport::HTTP;
use SOAP::Transport::HTTP::Plack;
use Yandex::SOAP::UTF8Serializer;
use Yandex::I18n;

use API::Serializer;

my $server = SOAP::Transport::HTTP::Plack
    -> serializer( new API::Serializer('utf8') )
    -> deserializer( new Yandex::SOAP::UTF8Deserializer::Masked('utf8') )
    -> dispatch_to('API');

# запрещаем одному запросу генерить больше мегабайта error.log
# use Yandex::PerlIO::via::Truncate;
# Yandex::PerlIO::via::Truncate::init(\*STDERR, 1_000_000);

sub handler
{
    my ($r) = @_;

    local $SOAP::Constants::DO_NOT_USE_CHARSET = 0;

    # Инициализируем локаль по умолчанию en для SOAP. Поскольку основная инициализация производится позже, все ошибки отсюда
    # будут возвращаться в локали, установленной в данный момент.
    Yandex::I18n::init_i18n('en');

    # получаем название метода для записи в profile.log
    my $header_method_name = 'null';
    if (defined $r->headers->header('SOAPAction')) {
        $r->headers->header('SOAPAction') =~ /[\#\/](\w+)/;
        $header_method_name = $1;
        warn "Strange soap header SOAPAction: ".($r->headers->header('SOAPAction') || '') if !$header_method_name;
    }

    # обыкновенная передача дополнительных параметров в handler работает подозрительно,
    # поэтому свои дополнительные параметры (версию, объект Plack::Request) передаем через глобальные переменные
    # версия апи, к которой обращается пользователь
    ## apache2,plack: с libplack-perl=0.9982-2ya и apache1 $r->uri содержит странное -- регулярное выражение из LocationMatch
    ## ('http://8805.beta.direct.yandex.ru:14443%5E/api/v[0-9]+(/live)*/*$/api/v4/').
    ## с apache2 лучше: $r->uri регулярного выражения не содержит, но зато содержит полный адрес ('http://test2-direct.yandex.ru:14443/api/v4/'),
    ## а код get_api_version_by_uri на это не рассчитан. TODO после полного перехода на apache2 снова посмотреть и перейти на $r->uri,
    ## пока используем $r->request_uri
    local ($API::api_version, $API::latest, $API::api_version_full, $API::api_wsdl_subversion) = get_api_version_by_uri($r->request_uri);
    $API::api_wsdl_subversion //= ''; # set to '' unless defined to avoid warnings

    # объект Plack::Request
    local $API::plack_request = $r;

    my $res = $server->handler(@_);

    if(@{$r->env->{extra_headers} // []}) {
        push $res->[1], @{$r->env->{extra_headers}};
    }

    return $res;
}

1;
