package Balance2;

=pod

=encoding utf8

    $Id:$

=head1 NAME

    Balance2

=head1 DESCRIPTION

    Наивная обертка над Sandbox::Balance превращающая Balance.Method в Balance2.Method

    Служит по только для работы agencyclients.add, который использует Balance2
    интерфейс к балансу ввиду наличия реализации такового клиента в Java

    Снаружи не виден. Перловая часть ходит в Sandbox::Balance

    Возвращают TSV
        GetDirectBrand
        GetDirectDiscount
        GetClientNDS

    Возвращают один объект
        GetBank
        EditPassport
        ListClientPassports
        GetPartnerContracts

    Возвращает три значения
        GetFirmCountryCurrency
        CreateClient

    См. ru.yandex.direct.balance.client.BalanceClient в аркадии

=cut

use Direct::Modern;

use Sandbox::Balance;

my $BALANCE1 = 'Balance';

sub CreateClient {
    my ($self, $operator_uid, @params) = @_;
    return _proxy_method_expect_3_values('CreateClient', $operator_uid, @params);
}

sub GetFirmCountryCurrency {
    my ($self, $operator_uid, @params) = @_;
    return _proxy_method_expect_3_values('GetFirmCountryCurrency', $operator_uid, @params);
}

sub CreateUserClientAssociation {
    my ($self, $operator_uid, @params) = @_;
    return _proxy_method_expect_2_values('CreateUserClientAssociation', $operator_uid, @params);
}

sub ListClientPassports {
    my ($self, $operator_uid, @params) = @_;
    return _proxy_method_as_is('ListClientPassports', $operator_uid, @params);
}

sub EditPassport {
    my ($self, $operator_uid, @params) = @_;
    return _proxy_method_as_is('EditPassport', $operator_uid, @params);
}

sub _proxy_method_as_is {
    my ($method, $operator_uid, @params) = @_;
    return $BALANCE1->$method($operator_uid, @params);
}

sub _proxy_method_expect_one_value {
    my ($method, $operator_uid, @params) = @_;
    my @result = $BALANCE1->$method($operator_uid, @params);
    return [
        0,
        "SUCCESS",
        \@result
    ];
}

sub _proxy_method_expect_2_values {
    my ($method, $operator_uid, @params) = @_;
    my @result = $BALANCE1->$method($operator_uid, @params);
    return [
        $result[0],
        $result[1] == 0 ? "SUCCESS" : $result[1],
    ];
}

sub _proxy_method_expect_3_values {
    my ($method, $operator_uid, @params) = @_;
    my @result = $BALANCE1->$method($operator_uid, @params);
    return [
        $result[0],
        $result[1] == 0 ? "SUCCESS" : $result[1],
        $result[2]
    ];
}

1;
